/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse;

public class ListProposalsPublisher
implements SdkPublisher<ListProposalsResponse> {
    private final ManagedBlockchainAsyncClient client;
    private final ListProposalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProposalsPublisher(ManagedBlockchainAsyncClient client, ListProposalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProposalsPublisher(ManagedBlockchainAsyncClient client, ListProposalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProposalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProposalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProposalsResponseFetcher
    implements AsyncPageFetcher<ListProposalsResponse> {
        private ListProposalsResponseFetcher() {
        }

        public boolean hasNextPage(ListProposalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProposalsResponse> nextPage(ListProposalsResponse previousPage) {
            if (previousPage == null) {
                return ListProposalsPublisher.this.client.listProposals(ListProposalsPublisher.this.firstRequest);
            }
            return ListProposalsPublisher.this.client.listProposals((ListProposalsRequest)((Object)ListProposalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

