/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ProposalActions;
import software.amazon.awssdk.services.managedblockchain.model.ProposalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Proposal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Proposal> {
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposalId").getter(Proposal.getter(Proposal::proposalId)).setter(Proposal.setter(Builder::proposalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalId").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(Proposal.getter(Proposal::networkId)).setter(Proposal.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Proposal.getter(Proposal::description)).setter(Proposal.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ProposalActions> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(Proposal.getter(Proposal::actions)).setter(Proposal.setter(Builder::actions)).constructor(ProposalActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()}).build();
    private static final SdkField<String> PROPOSED_BY_MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposedByMemberId").getter(Proposal.getter(Proposal::proposedByMemberId)).setter(Proposal.setter(Builder::proposedByMemberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberId").build()}).build();
    private static final SdkField<String> PROPOSED_BY_MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposedByMemberName").getter(Proposal.getter(Proposal::proposedByMemberName)).setter(Proposal.setter(Builder::proposedByMemberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Proposal.getter(Proposal::statusAsString)).setter(Proposal.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(Proposal.getter(Proposal::creationDate)).setter(Proposal.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(Proposal.getter(Proposal::expirationDate)).setter(Proposal.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> YES_VOTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("YesVoteCount").getter(Proposal.getter(Proposal::yesVoteCount)).setter(Proposal.setter(Builder::yesVoteCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YesVoteCount").build()}).build();
    private static final SdkField<Integer> NO_VOTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NoVoteCount").getter(Proposal.getter(Proposal::noVoteCount)).setter(Proposal.setter(Builder::noVoteCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoVoteCount").build()}).build();
    private static final SdkField<Integer> OUTSTANDING_VOTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutstandingVoteCount").getter(Proposal.getter(Proposal::outstandingVoteCount)).setter(Proposal.setter(Builder::outstandingVoteCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutstandingVoteCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_ID_FIELD, NETWORK_ID_FIELD, DESCRIPTION_FIELD, ACTIONS_FIELD, PROPOSED_BY_MEMBER_ID_FIELD, PROPOSED_BY_MEMBER_NAME_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, EXPIRATION_DATE_FIELD, YES_VOTE_COUNT_FIELD, NO_VOTE_COUNT_FIELD, OUTSTANDING_VOTE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String proposalId;
    private final String networkId;
    private final String description;
    private final ProposalActions actions;
    private final String proposedByMemberId;
    private final String proposedByMemberName;
    private final String status;
    private final Instant creationDate;
    private final Instant expirationDate;
    private final Integer yesVoteCount;
    private final Integer noVoteCount;
    private final Integer outstandingVoteCount;

    private Proposal(BuilderImpl builder) {
        this.proposalId = builder.proposalId;
        this.networkId = builder.networkId;
        this.description = builder.description;
        this.actions = builder.actions;
        this.proposedByMemberId = builder.proposedByMemberId;
        this.proposedByMemberName = builder.proposedByMemberName;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.expirationDate = builder.expirationDate;
        this.yesVoteCount = builder.yesVoteCount;
        this.noVoteCount = builder.noVoteCount;
        this.outstandingVoteCount = builder.outstandingVoteCount;
    }

    public final String proposalId() {
        return this.proposalId;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String description() {
        return this.description;
    }

    public final ProposalActions actions() {
        return this.actions;
    }

    public final String proposedByMemberId() {
        return this.proposedByMemberId;
    }

    public final String proposedByMemberName() {
        return this.proposedByMemberName;
    }

    public final ProposalStatus status() {
        return ProposalStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final Integer yesVoteCount() {
        return this.yesVoteCount;
    }

    public final Integer noVoteCount() {
        return this.noVoteCount;
    }

    public final Integer outstandingVoteCount() {
        return this.outstandingVoteCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedByMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedByMemberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.yesVoteCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.noVoteCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.outstandingVoteCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Proposal)) {
            return false;
        }
        Proposal other = (Proposal)obj;
        return Objects.equals(this.proposalId(), other.proposalId()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.proposedByMemberId(), other.proposedByMemberId()) && Objects.equals(this.proposedByMemberName(), other.proposedByMemberName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.yesVoteCount(), other.yesVoteCount()) && Objects.equals(this.noVoteCount(), other.noVoteCount()) && Objects.equals(this.outstandingVoteCount(), other.outstandingVoteCount());
    }

    public final String toString() {
        return ToString.builder((String)"Proposal").add("ProposalId", (Object)this.proposalId()).add("NetworkId", (Object)this.networkId()).add("Description", (Object)this.description()).add("Actions", (Object)this.actions()).add("ProposedByMemberId", (Object)this.proposedByMemberId()).add("ProposedByMemberName", (Object)this.proposedByMemberName()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("ExpirationDate", (Object)this.expirationDate()).add("YesVoteCount", (Object)this.yesVoteCount()).add("NoVoteCount", (Object)this.noVoteCount()).add("OutstandingVoteCount", (Object)this.outstandingVoteCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProposalId": {
                return Optional.ofNullable(clazz.cast(this.proposalId()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "ProposedByMemberId": {
                return Optional.ofNullable(clazz.cast(this.proposedByMemberId()));
            }
            case "ProposedByMemberName": {
                return Optional.ofNullable(clazz.cast(this.proposedByMemberName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "YesVoteCount": {
                return Optional.ofNullable(clazz.cast(this.yesVoteCount()));
            }
            case "NoVoteCount": {
                return Optional.ofNullable(clazz.cast(this.noVoteCount()));
            }
            case "OutstandingVoteCount": {
                return Optional.ofNullable(clazz.cast(this.outstandingVoteCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Proposal, T> g) {
        return obj -> g.apply((Proposal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proposalId;
        private String networkId;
        private String description;
        private ProposalActions actions;
        private String proposedByMemberId;
        private String proposedByMemberName;
        private String status;
        private Instant creationDate;
        private Instant expirationDate;
        private Integer yesVoteCount;
        private Integer noVoteCount;
        private Integer outstandingVoteCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Proposal model) {
            this.proposalId(model.proposalId);
            this.networkId(model.networkId);
            this.description(model.description);
            this.actions(model.actions);
            this.proposedByMemberId(model.proposedByMemberId);
            this.proposedByMemberName(model.proposedByMemberName);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.expirationDate(model.expirationDate);
            this.yesVoteCount(model.yesVoteCount);
            this.noVoteCount(model.noVoteCount);
            this.outstandingVoteCount(model.outstandingVoteCount);
        }

        public final String getProposalId() {
            return this.proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ProposalActions.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        @Override
        public final Builder actions(ProposalActions actions) {
            this.actions = actions;
            return this;
        }

        public final void setActions(ProposalActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        public final String getProposedByMemberId() {
            return this.proposedByMemberId;
        }

        @Override
        public final Builder proposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
            return this;
        }

        public final void setProposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
        }

        public final String getProposedByMemberName() {
            return this.proposedByMemberName;
        }

        @Override
        public final Builder proposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
            return this;
        }

        public final void setProposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProposalStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Integer getYesVoteCount() {
            return this.yesVoteCount;
        }

        @Override
        public final Builder yesVoteCount(Integer yesVoteCount) {
            this.yesVoteCount = yesVoteCount;
            return this;
        }

        public final void setYesVoteCount(Integer yesVoteCount) {
            this.yesVoteCount = yesVoteCount;
        }

        public final Integer getNoVoteCount() {
            return this.noVoteCount;
        }

        @Override
        public final Builder noVoteCount(Integer noVoteCount) {
            this.noVoteCount = noVoteCount;
            return this;
        }

        public final void setNoVoteCount(Integer noVoteCount) {
            this.noVoteCount = noVoteCount;
        }

        public final Integer getOutstandingVoteCount() {
            return this.outstandingVoteCount;
        }

        @Override
        public final Builder outstandingVoteCount(Integer outstandingVoteCount) {
            this.outstandingVoteCount = outstandingVoteCount;
            return this;
        }

        public final void setOutstandingVoteCount(Integer outstandingVoteCount) {
            this.outstandingVoteCount = outstandingVoteCount;
        }

        public Proposal build() {
            return new Proposal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Proposal> {
        public Builder proposalId(String var1);

        public Builder networkId(String var1);

        public Builder description(String var1);

        public Builder actions(ProposalActions var1);

        default public Builder actions(Consumer<ProposalActions.Builder> actions) {
            return this.actions((ProposalActions)((ProposalActions.Builder)ProposalActions.builder().applyMutation(actions)).build());
        }

        public Builder proposedByMemberId(String var1);

        public Builder proposedByMemberName(String var1);

        public Builder status(String var1);

        public Builder status(ProposalStatus var1);

        public Builder creationDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder yesVoteCount(Integer var1);

        public Builder noVoteCount(Integer var1);

        public Builder outstandingVoteCount(Integer var1);
    }
}

