/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodeRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, CreateNodeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateNodeRequest.getter(CreateNodeRequest::clientRequestToken)).setter(CreateNodeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(CreateNodeRequest.getter(CreateNodeRequest::networkId)).setter(CreateNodeRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(CreateNodeRequest.getter(CreateNodeRequest::memberId)).setter(CreateNodeRequest.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberId").build()}).build();
    private static final SdkField<NodeConfiguration> NODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeConfiguration").getter(CreateNodeRequest.getter(CreateNodeRequest::nodeConfiguration)).setter(CreateNodeRequest.setter(Builder::nodeConfiguration)).constructor(NodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, NETWORK_ID_FIELD, MEMBER_ID_FIELD, NODE_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String networkId;
    private final String memberId;
    private final NodeConfiguration nodeConfiguration;

    private CreateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.nodeConfiguration = builder.nodeConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final NodeConfiguration nodeConfiguration() {
        return this.nodeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRequest)) {
            return false;
        }
        CreateNodeRequest other = (CreateNodeRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.nodeConfiguration(), other.nodeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNodeRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("NetworkId", (Object)this.networkId()).add("MemberId", (Object)this.memberId()).add("NodeConfiguration", (Object)this.nodeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "NodeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nodeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRequest, T> g) {
        return obj -> g.apply((CreateNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String networkId;
        private String memberId;
        private NodeConfiguration nodeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.networkId(model.networkId);
            this.memberId(model.memberId);
            this.nodeConfiguration(model.nodeConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final NodeConfiguration.Builder getNodeConfiguration() {
            return this.nodeConfiguration != null ? this.nodeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nodeConfiguration(NodeConfiguration nodeConfiguration) {
            this.nodeConfiguration = nodeConfiguration;
            return this;
        }

        public final void setNodeConfiguration(NodeConfiguration.BuilderImpl nodeConfiguration) {
            this.nodeConfiguration = nodeConfiguration != null ? nodeConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeRequest build() {
            return new CreateNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodeRequest> {
        public Builder clientRequestToken(String var1);

        public Builder networkId(String var1);

        public Builder memberId(String var1);

        public Builder nodeConfiguration(NodeConfiguration var1);

        default public Builder nodeConfiguration(Consumer<NodeConfiguration.Builder> nodeConfiguration) {
            return this.nodeConfiguration((NodeConfiguration)((NodeConfiguration.Builder)NodeConfiguration.builder().applyMutation(nodeConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

