/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.PrivateNetworkConfiguration;
import software.amazon.awssdk.services.mailmanager.model.PublicNetworkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkConfiguration> {
    private static final SdkField<PublicNetworkConfiguration> PUBLIC_NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicNetworkConfiguration").getter(NetworkConfiguration.getter(NetworkConfiguration::publicNetworkConfiguration)).setter(NetworkConfiguration.setter(Builder::publicNetworkConfiguration)).constructor(PublicNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicNetworkConfiguration").build()}).build();
    private static final SdkField<PrivateNetworkConfiguration> PRIVATE_NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateNetworkConfiguration").getter(NetworkConfiguration.getter(NetworkConfiguration::privateNetworkConfiguration)).setter(NetworkConfiguration.setter(Builder::privateNetworkConfiguration)).constructor(PrivateNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateNetworkConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_NETWORK_CONFIGURATION_FIELD, PRIVATE_NETWORK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PublicNetworkConfiguration publicNetworkConfiguration;
    private final PrivateNetworkConfiguration privateNetworkConfiguration;
    private final Type type;

    private NetworkConfiguration(BuilderImpl builder) {
        this.publicNetworkConfiguration = builder.publicNetworkConfiguration;
        this.privateNetworkConfiguration = builder.privateNetworkConfiguration;
        this.type = builder.type;
    }

    public final PublicNetworkConfiguration publicNetworkConfiguration() {
        return this.publicNetworkConfiguration;
    }

    public final PrivateNetworkConfiguration privateNetworkConfiguration() {
        return this.privateNetworkConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicNetworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateNetworkConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration)obj;
        return Objects.equals(this.publicNetworkConfiguration(), other.publicNetworkConfiguration()) && Objects.equals(this.privateNetworkConfiguration(), other.privateNetworkConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkConfiguration").add("PublicNetworkConfiguration", (Object)this.publicNetworkConfiguration()).add("PrivateNetworkConfiguration", (Object)this.privateNetworkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicNetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.publicNetworkConfiguration()));
            }
            case "PrivateNetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.privateNetworkConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static NetworkConfiguration fromPublicNetworkConfiguration(PublicNetworkConfiguration publicNetworkConfiguration) {
        return (NetworkConfiguration)NetworkConfiguration.builder().publicNetworkConfiguration(publicNetworkConfiguration).build();
    }

    public static NetworkConfiguration fromPublicNetworkConfiguration(Consumer<PublicNetworkConfiguration.Builder> publicNetworkConfiguration) {
        PublicNetworkConfiguration.Builder builder = PublicNetworkConfiguration.builder();
        publicNetworkConfiguration.accept(builder);
        return NetworkConfiguration.fromPublicNetworkConfiguration((PublicNetworkConfiguration)builder.build());
    }

    public static NetworkConfiguration fromPrivateNetworkConfiguration(PrivateNetworkConfiguration privateNetworkConfiguration) {
        return (NetworkConfiguration)NetworkConfiguration.builder().privateNetworkConfiguration(privateNetworkConfiguration).build();
    }

    public static NetworkConfiguration fromPrivateNetworkConfiguration(Consumer<PrivateNetworkConfiguration.Builder> privateNetworkConfiguration) {
        PrivateNetworkConfiguration.Builder builder = PrivateNetworkConfiguration.builder();
        privateNetworkConfiguration.accept(builder);
        return NetworkConfiguration.fromPrivateNetworkConfiguration((PrivateNetworkConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PublicNetworkConfiguration", PUBLIC_NETWORK_CONFIGURATION_FIELD);
        map.put("PrivateNetworkConfiguration", PRIVATE_NETWORK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PUBLIC_NETWORK_CONFIGURATION,
        PRIVATE_NETWORK_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PublicNetworkConfiguration publicNetworkConfiguration;
        private PrivateNetworkConfiguration privateNetworkConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            this.publicNetworkConfiguration(model.publicNetworkConfiguration);
            this.privateNetworkConfiguration(model.privateNetworkConfiguration);
        }

        public final PublicNetworkConfiguration.Builder getPublicNetworkConfiguration() {
            return this.publicNetworkConfiguration != null ? this.publicNetworkConfiguration.toBuilder() : null;
        }

        public final void setPublicNetworkConfiguration(PublicNetworkConfiguration.BuilderImpl publicNetworkConfiguration) {
            PublicNetworkConfiguration oldValue = this.publicNetworkConfiguration;
            this.publicNetworkConfiguration = publicNetworkConfiguration != null ? publicNetworkConfiguration.build() : null;
            this.handleUnionValueChange(Type.PUBLIC_NETWORK_CONFIGURATION, oldValue, this.publicNetworkConfiguration);
        }

        @Override
        public final Builder publicNetworkConfiguration(PublicNetworkConfiguration publicNetworkConfiguration) {
            PublicNetworkConfiguration oldValue = this.publicNetworkConfiguration;
            this.publicNetworkConfiguration = publicNetworkConfiguration;
            this.handleUnionValueChange(Type.PUBLIC_NETWORK_CONFIGURATION, oldValue, this.publicNetworkConfiguration);
            return this;
        }

        public final PrivateNetworkConfiguration.Builder getPrivateNetworkConfiguration() {
            return this.privateNetworkConfiguration != null ? this.privateNetworkConfiguration.toBuilder() : null;
        }

        public final void setPrivateNetworkConfiguration(PrivateNetworkConfiguration.BuilderImpl privateNetworkConfiguration) {
            PrivateNetworkConfiguration oldValue = this.privateNetworkConfiguration;
            this.privateNetworkConfiguration = privateNetworkConfiguration != null ? privateNetworkConfiguration.build() : null;
            this.handleUnionValueChange(Type.PRIVATE_NETWORK_CONFIGURATION, oldValue, this.privateNetworkConfiguration);
        }

        @Override
        public final Builder privateNetworkConfiguration(PrivateNetworkConfiguration privateNetworkConfiguration) {
            PrivateNetworkConfiguration oldValue = this.privateNetworkConfiguration;
            this.privateNetworkConfiguration = privateNetworkConfiguration;
            this.handleUnionValueChange(Type.PRIVATE_NETWORK_CONFIGURATION, oldValue, this.privateNetworkConfiguration);
            return this;
        }

        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkConfiguration> {
        public Builder publicNetworkConfiguration(PublicNetworkConfiguration var1);

        default public Builder publicNetworkConfiguration(Consumer<PublicNetworkConfiguration.Builder> publicNetworkConfiguration) {
            return this.publicNetworkConfiguration((PublicNetworkConfiguration)((PublicNetworkConfiguration.Builder)PublicNetworkConfiguration.builder().applyMutation(publicNetworkConfiguration)).build());
        }

        public Builder privateNetworkConfiguration(PrivateNetworkConfiguration var1);

        default public Builder privateNetworkConfiguration(Consumer<PrivateNetworkConfiguration.Builder> privateNetworkConfiguration) {
            return this.privateNetworkConfiguration((PrivateNetworkConfiguration)((PrivateNetworkConfiguration.Builder)PrivateNetworkConfiguration.builder().applyMutation(privateNetworkConfiguration)).build());
        }
    }
}

