/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ImportJob;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse;

public class ListAddressListImportJobsPublisher
implements SdkPublisher<ListAddressListImportJobsResponse> {
    private final MailManagerAsyncClient client;
    private final ListAddressListImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAddressListImportJobsPublisher(MailManagerAsyncClient client, ListAddressListImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAddressListImportJobsPublisher(MailManagerAsyncClient client, ListAddressListImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAddressListImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAddressListImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportJob> importJobs() {
        Function<ListAddressListImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAddressListImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAddressListImportJobsResponseFetcher
    implements AsyncPageFetcher<ListAddressListImportJobsResponse> {
        private ListAddressListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddressListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAddressListImportJobsResponse> nextPage(ListAddressListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAddressListImportJobsPublisher.this.client.listAddressListImportJobs(ListAddressListImportJobsPublisher.this.firstRequest);
            }
            return ListAddressListImportJobsPublisher.this.client.listAddressListImportJobs((ListAddressListImportJobsRequest)((Object)ListAddressListImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

