/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.ArchiveRetention;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.services.mailmanager.model.Tag;
import software.amazon.awssdk.services.mailmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateArchiveRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, CreateArchiveRequest> {
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveName").getter(CreateArchiveRequest.getter(CreateArchiveRequest::archiveName)).setter(CreateArchiveRequest.setter(Builder::archiveName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateArchiveRequest.getter(CreateArchiveRequest::clientToken)).setter(CreateArchiveRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateArchiveRequest.getter(CreateArchiveRequest::kmsKeyArn)).setter(CreateArchiveRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<ArchiveRetention> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Retention").getter(CreateArchiveRequest.getter(CreateArchiveRequest::retention)).setter(CreateArchiveRequest.setter(Builder::retention)).constructor(ArchiveRetention::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateArchiveRequest.getter(CreateArchiveRequest::tags)).setter(CreateArchiveRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_NAME_FIELD, CLIENT_TOKEN_FIELD, KMS_KEY_ARN_FIELD, RETENTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateArchiveRequest.memberNameToFieldInitializer();
    private final String archiveName;
    private final String clientToken;
    private final String kmsKeyArn;
    private final ArchiveRetention retention;
    private final List<Tag> tags;

    private CreateArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.archiveName = builder.archiveName;
        this.clientToken = builder.clientToken;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.retention = builder.retention;
        this.tags = builder.tags;
    }

    public final String archiveName() {
        return this.archiveName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final ArchiveRetention retention() {
        return this.retention;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.retention());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateArchiveRequest)) {
            return false;
        }
        CreateArchiveRequest other = (CreateArchiveRequest)((Object)obj);
        return Objects.equals(this.archiveName(), other.archiveName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.retention(), other.retention()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateArchiveRequest").add("ArchiveName", (Object)this.archiveName()).add("ClientToken", (Object)this.clientToken()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Retention", (Object)this.retention()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveName": {
                return Optional.ofNullable(clazz.cast(this.archiveName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Retention", RETENTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateArchiveRequest, T> g) {
        return obj -> g.apply((CreateArchiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String archiveName;
        private String clientToken;
        private String kmsKeyArn;
        private ArchiveRetention retention;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateArchiveRequest model) {
            super(model);
            this.archiveName(model.archiveName);
            this.clientToken(model.clientToken);
            this.kmsKeyArn(model.kmsKeyArn);
            this.retention(model.retention);
            this.tags(model.tags);
        }

        public final String getArchiveName() {
            return this.archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final ArchiveRetention.Builder getRetention() {
            return this.retention != null ? this.retention.toBuilder() : null;
        }

        public final void setRetention(ArchiveRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        @Override
        public final Builder retention(ArchiveRetention retention) {
            this.retention = retention;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateArchiveRequest build() {
            return new CreateArchiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateArchiveRequest> {
        public Builder archiveName(String var1);

        public Builder clientToken(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder retention(ArchiveRetention var1);

        default public Builder retention(Consumer<ArchiveRetention.Builder> retention) {
            return this.retention((ArchiveRetention)((ArchiveRetention.Builder)ArchiveRetention.builder().applyMutation(retention)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

