/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.AddonInstance;
import software.amazon.awssdk.services.mailmanager.model.AddonInstancesCopier;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAddonInstancesResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, ListAddonInstancesResponse> {
    private static final SdkField<List<AddonInstance>> ADDON_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddonInstances").getter(ListAddonInstancesResponse.getter(ListAddonInstancesResponse::addonInstances)).setter(ListAddonInstancesResponse.setter(Builder::addonInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAddonInstancesResponse.getter(ListAddonInstancesResponse::nextToken)).setter(ListAddonInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAddonInstancesResponse.memberNameToFieldInitializer();
    private final List<AddonInstance> addonInstances;
    private final String nextToken;

    private ListAddonInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.addonInstances = builder.addonInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAddonInstances() {
        return this.addonInstances != null && !(this.addonInstances instanceof SdkAutoConstructList);
    }

    public final List<AddonInstance> addonInstances() {
        return this.addonInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddonInstances() ? this.addonInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAddonInstancesResponse)) {
            return false;
        }
        ListAddonInstancesResponse other = (ListAddonInstancesResponse)((Object)obj);
        return this.hasAddonInstances() == other.hasAddonInstances() && Objects.equals(this.addonInstances(), other.addonInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAddonInstancesResponse").add("AddonInstances", this.hasAddonInstances() ? this.addonInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddonInstances": {
                return Optional.ofNullable(clazz.cast(this.addonInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddonInstances", ADDON_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAddonInstancesResponse, T> g) {
        return obj -> g.apply((ListAddonInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private List<AddonInstance> addonInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAddonInstancesResponse model) {
            super(model);
            this.addonInstances(model.addonInstances);
            this.nextToken(model.nextToken);
        }

        public final List<AddonInstance.Builder> getAddonInstances() {
            List<AddonInstance.Builder> result = AddonInstancesCopier.copyToBuilder(this.addonInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonInstances(Collection<AddonInstance.BuilderImpl> addonInstances) {
            this.addonInstances = AddonInstancesCopier.copyFromBuilder(addonInstances);
        }

        @Override
        public final Builder addonInstances(Collection<AddonInstance> addonInstances) {
            this.addonInstances = AddonInstancesCopier.copy(addonInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonInstances(AddonInstance ... addonInstances) {
            this.addonInstances(Arrays.asList(addonInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonInstances(Consumer<AddonInstance.Builder> ... addonInstances) {
            this.addonInstances(Stream.of(addonInstances).map(c -> (AddonInstance)((AddonInstance.Builder)AddonInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAddonInstancesResponse build() {
            return new ListAddonInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAddonInstancesResponse> {
        public Builder addonInstances(Collection<AddonInstance> var1);

        public Builder addonInstances(AddonInstance ... var1);

        public Builder addonInstances(Consumer<AddonInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

