/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse;
import software.amazon.awssdk.services.mailmanager.model.SearchSummary;

public class ListArchiveSearchesIterable
implements SdkIterable<ListArchiveSearchesResponse> {
    private final MailManagerClient client;
    private final ListArchiveSearchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArchiveSearchesIterable(MailManagerClient client, ListArchiveSearchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListArchiveSearchesResponseFetcher();
    }

    public Iterator<ListArchiveSearchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchSummary> searches() {
        Function<ListArchiveSearchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.searches() != null) {
                return response.searches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArchiveSearchesResponseFetcher
    implements SyncPageFetcher<ListArchiveSearchesResponse> {
        private ListArchiveSearchesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveSearchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArchiveSearchesResponse nextPage(ListArchiveSearchesResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveSearchesIterable.this.client.listArchiveSearches(ListArchiveSearchesIterable.this.firstRequest);
            }
            return ListArchiveSearchesIterable.this.client.listArchiveSearches((ListArchiveSearchesRequest)((Object)ListArchiveSearchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

