/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse;
import software.amazon.awssdk.services.mailmanager.model.RuleSet;

public class ListRuleSetsPublisher
implements SdkPublisher<ListRuleSetsResponse> {
    private final MailManagerAsyncClient client;
    private final ListRuleSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRuleSetsPublisher(MailManagerAsyncClient client, ListRuleSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRuleSetsPublisher(MailManagerAsyncClient client, ListRuleSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRuleSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRuleSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleSet> ruleSets() {
        Function<ListRuleSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleSets() != null) {
                return response.ruleSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRuleSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRuleSetsResponseFetcher
    implements AsyncPageFetcher<ListRuleSetsResponse> {
        private ListRuleSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRuleSetsResponse> nextPage(ListRuleSetsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleSetsPublisher.this.client.listRuleSets(ListRuleSetsPublisher.this.firstRequest);
            }
            return ListRuleSetsPublisher.this.client.listRuleSets((ListRuleSetsRequest)((Object)ListRuleSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

