/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.NoAuthentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelayAuthentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelayAuthentication> {
    private static final SdkField<NoAuthentication> NO_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NoAuthentication").getter(RelayAuthentication.getter(RelayAuthentication::noAuthentication)).setter(RelayAuthentication.setter(Builder::noAuthentication)).constructor(NoAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoAuthentication").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(RelayAuthentication.getter(RelayAuthentication::secretArn)).setter(RelayAuthentication.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_AUTHENTICATION_FIELD, SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final NoAuthentication noAuthentication;
    private final String secretArn;
    private final Type type;

    private RelayAuthentication(BuilderImpl builder) {
        this.noAuthentication = builder.noAuthentication;
        this.secretArn = builder.secretArn;
        this.type = builder.type;
    }

    public final NoAuthentication noAuthentication() {
        return this.noAuthentication;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelayAuthentication)) {
            return false;
        }
        RelayAuthentication other = (RelayAuthentication)obj;
        return Objects.equals(this.noAuthentication(), other.noAuthentication()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"RelayAuthentication").add("NoAuthentication", (Object)this.noAuthentication()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoAuthentication": {
                return Optional.ofNullable(clazz.cast(this.noAuthentication()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public static RelayAuthentication fromNoAuthentication(NoAuthentication noAuthentication) {
        return (RelayAuthentication)RelayAuthentication.builder().noAuthentication(noAuthentication).build();
    }

    public static RelayAuthentication fromNoAuthentication(Consumer<NoAuthentication.Builder> noAuthentication) {
        NoAuthentication.Builder builder = NoAuthentication.builder();
        noAuthentication.accept(builder);
        return RelayAuthentication.fromNoAuthentication((NoAuthentication)builder.build());
    }

    public static RelayAuthentication fromSecretArn(String secretArn) {
        return (RelayAuthentication)RelayAuthentication.builder().secretArn(secretArn).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelayAuthentication, T> g) {
        return obj -> g.apply((RelayAuthentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NO_AUTHENTICATION,
        SECRET_ARN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NoAuthentication noAuthentication;
        private String secretArn;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelayAuthentication model) {
            this.noAuthentication(model.noAuthentication);
            this.secretArn(model.secretArn);
        }

        public final NoAuthentication.Builder getNoAuthentication() {
            return this.noAuthentication != null ? this.noAuthentication.toBuilder() : null;
        }

        public final void setNoAuthentication(NoAuthentication.BuilderImpl noAuthentication) {
            NoAuthentication oldValue = this.noAuthentication;
            this.noAuthentication = noAuthentication != null ? noAuthentication.build() : null;
            this.handleUnionValueChange(Type.NO_AUTHENTICATION, oldValue, this.noAuthentication);
        }

        @Override
        public final Builder noAuthentication(NoAuthentication noAuthentication) {
            NoAuthentication oldValue = this.noAuthentication;
            this.noAuthentication = noAuthentication;
            this.handleUnionValueChange(Type.NO_AUTHENTICATION, oldValue, this.noAuthentication);
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
        }

        @Override
        public final Builder secretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
            return this;
        }

        public RelayAuthentication build() {
            return new RelayAuthentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelayAuthentication> {
        public Builder noAuthentication(NoAuthentication var1);

        default public Builder noAuthentication(Consumer<NoAuthentication.Builder> noAuthentication) {
            return this.noAuthentication((NoAuthentication)((NoAuthentication.Builder)NoAuthentication.builder().applyMutation(noAuthentication)).build());
        }

        public Builder secretArn(String var1);
    }
}

