/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddonInstance;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse;

public class ListAddonInstancesIterable
implements SdkIterable<ListAddonInstancesResponse> {
    private final MailManagerClient client;
    private final ListAddonInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAddonInstancesIterable(MailManagerClient client, ListAddonInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAddonInstancesResponseFetcher();
    }

    public Iterator<ListAddonInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddonInstance> addonInstances() {
        Function<ListAddonInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.addonInstances() != null) {
                return response.addonInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAddonInstancesResponseFetcher
    implements SyncPageFetcher<ListAddonInstancesResponse> {
        private ListAddonInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAddonInstancesResponse nextPage(ListAddonInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAddonInstancesIterable.this.client.listAddonInstances(ListAddonInstancesIterable.this.firstRequest);
            }
            return ListAddonInstancesIterable.this.client.listAddonInstances((ListAddonInstancesRequest)((Object)ListAddonInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

