/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.SearchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchSummary> {
    private static final SdkField<String> SEARCH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchId").getter(SearchSummary.getter(SearchSummary::searchId)).setter(SearchSummary.setter(Builder::searchId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchId").build()}).build();
    private static final SdkField<SearchStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(SearchSummary.getter(SearchSummary::status)).setter(SearchSummary.setter(Builder::status)).constructor(SearchStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_ID_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String searchId;
    private final SearchStatus status;

    private SearchSummary(BuilderImpl builder) {
        this.searchId = builder.searchId;
        this.status = builder.status;
    }

    public final String searchId() {
        return this.searchId;
    }

    public final SearchStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSummary)) {
            return false;
        }
        SearchSummary other = (SearchSummary)obj;
        return Objects.equals(this.searchId(), other.searchId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSummary").add("SearchId", (Object)this.searchId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchId": {
                return Optional.ofNullable(clazz.cast(this.searchId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSummary, T> g) {
        return obj -> g.apply((SearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchId;
        private SearchStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSummary model) {
            this.searchId(model.searchId);
            this.status(model.status);
        }

        public final String getSearchId() {
            return this.searchId;
        }

        public final void setSearchId(String searchId) {
            this.searchId = searchId;
        }

        @Override
        public final Builder searchId(String searchId) {
            this.searchId = searchId;
            return this;
        }

        public final SearchStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        public SearchSummary build() {
            return new SearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchSummary> {
        public Builder searchId(String var1);

        public Builder status(SearchStatus var1);

        default public Builder status(Consumer<SearchStatus.Builder> status) {
            return this.status((SearchStatus)((SearchStatus.Builder)SearchStatus.builder().applyMutation(status)).build());
        }
    }
}

