/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.JobScheduleFrequency;
import software.amazon.awssdk.services.macie2.model.JobType;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSelector;
import software.amazon.awssdk.services.macie2.model.S3JobDefinition;
import software.amazon.awssdk.services.macie2.model.TagMapCopier;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClassificationJobRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, CreateClassificationJobRequest> {
    private static final SdkField<List<String>> ALLOW_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowListIds").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::allowListIds)).setter(CreateClassificationJobRequest.setter(Builder::allowListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowListIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::clientToken)).setter(CreateClassificationJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDataIdentifierIds").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::customDataIdentifierIds)).setter(CreateClassificationJobRequest.setter(Builder::customDataIdentifierIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::description)).setter(CreateClassificationJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("initialRun").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::initialRun)).setter(CreateClassificationJobRequest.setter(Builder::initialRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::jobTypeAsString)).setter(CreateClassificationJobRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<List<String>> MANAGED_DATA_IDENTIFIER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedDataIdentifierIds").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::managedDataIdentifierIds)).setter(CreateClassificationJobRequest.setter(Builder::managedDataIdentifierIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDataIdentifierSelector").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::managedDataIdentifierSelectorAsString)).setter(CreateClassificationJobRequest.setter(Builder::managedDataIdentifierSelector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierSelector").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::name)).setter(CreateClassificationJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3JobDefinition").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::s3JobDefinition)).setter(CreateClassificationJobRequest.setter(Builder::s3JobDefinition)).constructor(S3JobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()}).build();
    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("samplingPercentage").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::samplingPercentage)).setter(CreateClassificationJobRequest.setter(Builder::samplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build()}).build();
    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduleFrequency").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::scheduleFrequency)).setter(CreateClassificationJobRequest.setter(Builder::scheduleFrequency)).constructor(JobScheduleFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateClassificationJobRequest.getter(CreateClassificationJobRequest::tags)).setter(CreateClassificationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_LIST_IDS_FIELD, CLIENT_TOKEN_FIELD, CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_TYPE_FIELD, MANAGED_DATA_IDENTIFIER_IDS_FIELD, MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD, NAME_FIELD, S3_JOB_DEFINITION_FIELD, SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClassificationJobRequest.memberNameToFieldInitializer();
    private final List<String> allowListIds;
    private final String clientToken;
    private final List<String> customDataIdentifierIds;
    private final String description;
    private final Boolean initialRun;
    private final String jobType;
    private final List<String> managedDataIdentifierIds;
    private final String managedDataIdentifierSelector;
    private final String name;
    private final S3JobDefinition s3JobDefinition;
    private final Integer samplingPercentage;
    private final JobScheduleFrequency scheduleFrequency;
    private final Map<String, String> tags;

    private CreateClassificationJobRequest(BuilderImpl builder) {
        super(builder);
        this.allowListIds = builder.allowListIds;
        this.clientToken = builder.clientToken;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobType = builder.jobType;
        this.managedDataIdentifierIds = builder.managedDataIdentifierIds;
        this.managedDataIdentifierSelector = builder.managedDataIdentifierSelector;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.tags = builder.tags;
    }

    public final boolean hasAllowListIds() {
        return this.allowListIds != null && !(this.allowListIds instanceof SdkAutoConstructList);
    }

    public final List<String> allowListIds() {
        return this.allowListIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasCustomDataIdentifierIds() {
        return this.customDataIdentifierIds != null && !(this.customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    public final List<String> customDataIdentifierIds() {
        return this.customDataIdentifierIds;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean initialRun() {
        return this.initialRun;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final boolean hasManagedDataIdentifierIds() {
        return this.managedDataIdentifierIds != null && !(this.managedDataIdentifierIds instanceof SdkAutoConstructList);
    }

    public final List<String> managedDataIdentifierIds() {
        return this.managedDataIdentifierIds;
    }

    public final ManagedDataIdentifierSelector managedDataIdentifierSelector() {
        return ManagedDataIdentifierSelector.fromValue(this.managedDataIdentifierSelector);
    }

    public final String managedDataIdentifierSelectorAsString() {
        return this.managedDataIdentifierSelector;
    }

    public final String name() {
        return this.name;
    }

    public final S3JobDefinition s3JobDefinition() {
        return this.s3JobDefinition;
    }

    public final Integer samplingPercentage() {
        return this.samplingPercentage;
    }

    public final JobScheduleFrequency scheduleFrequency() {
        return this.scheduleFrequency;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowListIds() ? this.allowListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDataIdentifierIds() ? this.customDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedDataIdentifierIds() ? this.managedDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDataIdentifierSelectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassificationJobRequest)) {
            return false;
        }
        CreateClassificationJobRequest other = (CreateClassificationJobRequest)((Object)obj);
        return this.hasAllowListIds() == other.hasAllowListIds() && Objects.equals(this.allowListIds(), other.allowListIds()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasCustomDataIdentifierIds() == other.hasCustomDataIdentifierIds() && Objects.equals(this.customDataIdentifierIds(), other.customDataIdentifierIds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.initialRun(), other.initialRun()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && this.hasManagedDataIdentifierIds() == other.hasManagedDataIdentifierIds() && Objects.equals(this.managedDataIdentifierIds(), other.managedDataIdentifierIds()) && Objects.equals(this.managedDataIdentifierSelectorAsString(), other.managedDataIdentifierSelectorAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.s3JobDefinition(), other.s3JobDefinition()) && Objects.equals(this.samplingPercentage(), other.samplingPercentage()) && Objects.equals(this.scheduleFrequency(), other.scheduleFrequency()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClassificationJobRequest").add("AllowListIds", this.hasAllowListIds() ? this.allowListIds() : null).add("ClientToken", (Object)this.clientToken()).add("CustomDataIdentifierIds", this.hasCustomDataIdentifierIds() ? this.customDataIdentifierIds() : null).add("Description", (Object)this.description()).add("InitialRun", (Object)this.initialRun()).add("JobType", (Object)this.jobTypeAsString()).add("ManagedDataIdentifierIds", this.hasManagedDataIdentifierIds() ? this.managedDataIdentifierIds() : null).add("ManagedDataIdentifierSelector", (Object)this.managedDataIdentifierSelectorAsString()).add("Name", (Object)this.name()).add("S3JobDefinition", (Object)this.s3JobDefinition()).add("SamplingPercentage", (Object)this.samplingPercentage()).add("ScheduleFrequency", (Object)this.scheduleFrequency()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowListIds": {
                return Optional.ofNullable(clazz.cast(this.allowListIds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "customDataIdentifierIds": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifierIds()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "initialRun": {
                return Optional.ofNullable(clazz.cast(this.initialRun()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "managedDataIdentifierIds": {
                return Optional.ofNullable(clazz.cast(this.managedDataIdentifierIds()));
            }
            case "managedDataIdentifierSelector": {
                return Optional.ofNullable(clazz.cast(this.managedDataIdentifierSelectorAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3JobDefinition": {
                return Optional.ofNullable(clazz.cast(this.s3JobDefinition()));
            }
            case "samplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.samplingPercentage()));
            }
            case "scheduleFrequency": {
                return Optional.ofNullable(clazz.cast(this.scheduleFrequency()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowListIds", ALLOW_LIST_IDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("customDataIdentifierIds", CUSTOM_DATA_IDENTIFIER_IDS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("initialRun", INITIAL_RUN_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("managedDataIdentifierIds", MANAGED_DATA_IDENTIFIER_IDS_FIELD);
        map.put("managedDataIdentifierSelector", MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD);
        map.put("name", NAME_FIELD);
        map.put("s3JobDefinition", S3_JOB_DEFINITION_FIELD);
        map.put("samplingPercentage", SAMPLING_PERCENTAGE_FIELD);
        map.put("scheduleFrequency", SCHEDULE_FREQUENCY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClassificationJobRequest, T> g) {
        return obj -> g.apply((CreateClassificationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private List<String> allowListIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean initialRun;
        private String jobType;
        private List<String> managedDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();
        private String managedDataIdentifierSelector;
        private String name;
        private S3JobDefinition s3JobDefinition;
        private Integer samplingPercentage;
        private JobScheduleFrequency scheduleFrequency;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassificationJobRequest model) {
            super(model);
            this.allowListIds(model.allowListIds);
            this.clientToken(model.clientToken);
            this.customDataIdentifierIds(model.customDataIdentifierIds);
            this.description(model.description);
            this.initialRun(model.initialRun);
            this.jobType(model.jobType);
            this.managedDataIdentifierIds(model.managedDataIdentifierIds);
            this.managedDataIdentifierSelector(model.managedDataIdentifierSelector);
            this.name(model.name);
            this.s3JobDefinition(model.s3JobDefinition);
            this.samplingPercentage(model.samplingPercentage);
            this.scheduleFrequency(model.scheduleFrequency);
            this.tags(model.tags);
        }

        public final Collection<String> getAllowListIds() {
            if (this.allowListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowListIds;
        }

        public final void setAllowListIds(Collection<String> allowListIds) {
            this.allowListIds = ___listOf__stringCopier.copy(allowListIds);
        }

        @Override
        public final Builder allowListIds(Collection<String> allowListIds) {
            this.allowListIds = ___listOf__stringCopier.copy(allowListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowListIds(String ... allowListIds) {
            this.allowListIds(Arrays.asList(allowListIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            if (this.customDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDataIdentifierIds;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String ... customDataIdentifierIds) {
            this.customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getInitialRun() {
            return this.initialRun;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Collection<String> getManagedDataIdentifierIds() {
            if (this.managedDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedDataIdentifierIds;
        }

        public final void setManagedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
        }

        @Override
        public final Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedDataIdentifierIds(String ... managedDataIdentifierIds) {
            this.managedDataIdentifierIds(Arrays.asList(managedDataIdentifierIds));
            return this;
        }

        public final String getManagedDataIdentifierSelector() {
            return this.managedDataIdentifierSelector;
        }

        public final void setManagedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
        }

        @Override
        public final Builder managedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
            return this;
        }

        @Override
        public final Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector(managedDataIdentifierSelector == null ? null : managedDataIdentifierSelector.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return this.s3JobDefinition != null ? this.s3JobDefinition.toBuilder() : null;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final Integer getSamplingPercentage() {
            return this.samplingPercentage;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return this.scheduleFrequency != null ? this.scheduleFrequency.toBuilder() : null;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClassificationJobRequest build() {
            return new CreateClassificationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClassificationJobRequest> {
        public Builder allowListIds(Collection<String> var1);

        public Builder allowListIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder customDataIdentifierIds(Collection<String> var1);

        public Builder customDataIdentifierIds(String ... var1);

        public Builder description(String var1);

        public Builder initialRun(Boolean var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder managedDataIdentifierIds(Collection<String> var1);

        public Builder managedDataIdentifierIds(String ... var1);

        public Builder managedDataIdentifierSelector(String var1);

        public Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector var1);

        public Builder name(String var1);

        public Builder s3JobDefinition(S3JobDefinition var1);

        default public Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return this.s3JobDefinition((S3JobDefinition)((S3JobDefinition.Builder)S3JobDefinition.builder().applyMutation(s3JobDefinition)).build());
        }

        public Builder samplingPercentage(Integer var1);

        public Builder scheduleFrequency(JobScheduleFrequency var1);

        default public Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return this.scheduleFrequency((JobScheduleFrequency)((JobScheduleFrequency.Builder)JobScheduleFrequency.builder().applyMutation(scheduleFrequency)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

