/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties;
import software.amazon.awssdk.services.macie2.model.BucketCriteriaCopier;
import software.amazon.awssdk.services.macie2.model.BucketSortCriteria;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBucketsRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, DescribeBucketsRequest> {
    private static final SdkField<Map<String, BucketCriteriaAdditionalProperties>> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("criteria").getter(DescribeBucketsRequest.getter(DescribeBucketsRequest::criteria)).setter(DescribeBucketsRequest.setter(Builder::criteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BucketCriteriaAdditionalProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeBucketsRequest.getter(DescribeBucketsRequest::maxResults)).setter(DescribeBucketsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeBucketsRequest.getter(DescribeBucketsRequest::nextToken)).setter(DescribeBucketsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<BucketSortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortCriteria").getter(DescribeBucketsRequest.getter(DescribeBucketsRequest::sortCriteria)).setter(DescribeBucketsRequest.setter(Builder::sortCriteria)).constructor(BucketSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBucketsRequest.memberNameToFieldInitializer();
    private final Map<String, BucketCriteriaAdditionalProperties> criteria;
    private final Integer maxResults;
    private final String nextToken;
    private final BucketSortCriteria sortCriteria;

    private DescribeBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.criteria = builder.criteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    public final boolean hasCriteria() {
        return this.criteria != null && !(this.criteria instanceof SdkAutoConstructMap);
    }

    public final Map<String, BucketCriteriaAdditionalProperties> criteria() {
        return this.criteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final BucketSortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCriteria() ? this.criteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBucketsRequest)) {
            return false;
        }
        DescribeBucketsRequest other = (DescribeBucketsRequest)((Object)obj);
        return this.hasCriteria() == other.hasCriteria() && Objects.equals(this.criteria(), other.criteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBucketsRequest").add("Criteria", this.hasCriteria() ? this.criteria() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("criteria", CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBucketsRequest, T> g) {
        return obj -> g.apply((DescribeBucketsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private Map<String, BucketCriteriaAdditionalProperties> criteria = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;
        private BucketSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBucketsRequest model) {
            super(model);
            this.criteria(model.criteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortCriteria(model.sortCriteria);
        }

        public final Map<String, BucketCriteriaAdditionalProperties.Builder> getCriteria() {
            Map<String, BucketCriteriaAdditionalProperties.Builder> result = BucketCriteriaCopier.copyToBuilder(this.criteria);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCriteria(Map<String, BucketCriteriaAdditionalProperties.BuilderImpl> criteria) {
            this.criteria = BucketCriteriaCopier.copyFromBuilder(criteria);
        }

        @Override
        public final Builder criteria(Map<String, BucketCriteriaAdditionalProperties> criteria) {
            this.criteria = BucketCriteriaCopier.copy(criteria);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final BucketSortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(BucketSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(BucketSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBucketsRequest build() {
            return new DescribeBucketsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBucketsRequest> {
        public Builder criteria(Map<String, BucketCriteriaAdditionalProperties> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortCriteria(BucketSortCriteria var1);

        default public Builder sortCriteria(Consumer<BucketSortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((BucketSortCriteria)((BucketSortCriteria.Builder)BucketSortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

