/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.ClassificationScopeUpdateOperation;
import software.amazon.awssdk.services.macie2.model.___listOfS3BucketNameCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ClassificationScopeExclusionUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ClassificationScopeExclusionUpdate> {
    private static final SdkField<List<String>> BUCKET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bucketNames").getter(S3ClassificationScopeExclusionUpdate.getter(S3ClassificationScopeExclusionUpdate::bucketNames)).setter(S3ClassificationScopeExclusionUpdate.setter(Builder::bucketNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(S3ClassificationScopeExclusionUpdate.getter(S3ClassificationScopeExclusionUpdate::operationAsString)).setter(S3ClassificationScopeExclusionUpdate.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAMES_FIELD, OPERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ClassificationScopeExclusionUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> bucketNames;
    private final String operation;

    private S3ClassificationScopeExclusionUpdate(BuilderImpl builder) {
        this.bucketNames = builder.bucketNames;
        this.operation = builder.operation;
    }

    public final boolean hasBucketNames() {
        return this.bucketNames != null && !(this.bucketNames instanceof SdkAutoConstructList);
    }

    public final List<String> bucketNames() {
        return this.bucketNames;
    }

    public final ClassificationScopeUpdateOperation operation() {
        return ClassificationScopeUpdateOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBucketNames() ? this.bucketNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ClassificationScopeExclusionUpdate)) {
            return false;
        }
        S3ClassificationScopeExclusionUpdate other = (S3ClassificationScopeExclusionUpdate)obj;
        return this.hasBucketNames() == other.hasBucketNames() && Objects.equals(this.bucketNames(), other.bucketNames()) && Objects.equals(this.operationAsString(), other.operationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3ClassificationScopeExclusionUpdate").add("BucketNames", this.hasBucketNames() ? this.bucketNames() : null).add("Operation", (Object)this.operationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketNames": {
                return Optional.ofNullable(clazz.cast(this.bucketNames()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucketNames", BUCKET_NAMES_FIELD);
        map.put("operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ClassificationScopeExclusionUpdate, T> g) {
        return obj -> g.apply((S3ClassificationScopeExclusionUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> bucketNames = DefaultSdkAutoConstructList.getInstance();
        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ClassificationScopeExclusionUpdate model) {
            this.bucketNames(model.bucketNames);
            this.operation(model.operation);
        }

        public final Collection<String> getBucketNames() {
            if (this.bucketNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bucketNames;
        }

        public final void setBucketNames(Collection<String> bucketNames) {
            this.bucketNames = ___listOfS3BucketNameCopier.copy(bucketNames);
        }

        @Override
        public final Builder bucketNames(Collection<String> bucketNames) {
            this.bucketNames = ___listOfS3BucketNameCopier.copy(bucketNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketNames(String ... bucketNames) {
            this.bucketNames(Arrays.asList(bucketNames));
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(ClassificationScopeUpdateOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public S3ClassificationScopeExclusionUpdate build() {
            return new S3ClassificationScopeExclusionUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ClassificationScopeExclusionUpdate> {
        public Builder bucketNames(Collection<String> var1);

        public Builder bucketNames(String ... var1);

        public Builder operation(String var1);

        public Builder operation(ClassificationScopeUpdateOperation var1);
    }
}

