/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SensitivityAggregations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SensitivityAggregations> {
    private static final SdkField<Long> CLASSIFIABLE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("classifiableSizeInBytes").getter(SensitivityAggregations.getter(SensitivityAggregations::classifiableSizeInBytes)).setter(SensitivityAggregations.setter(Builder::classifiableSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableSizeInBytes").build()}).build();
    private static final SdkField<Long> PUBLICLY_ACCESSIBLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("publiclyAccessibleCount").getter(SensitivityAggregations.getter(SensitivityAggregations::publiclyAccessibleCount)).setter(SensitivityAggregations.setter(Builder::publiclyAccessibleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessibleCount").build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalCount").getter(SensitivityAggregations.getter(SensitivityAggregations::totalCount)).setter(SensitivityAggregations.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()}).build();
    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalSizeInBytes").getter(SensitivityAggregations.getter(SensitivityAggregations::totalSizeInBytes)).setter(SensitivityAggregations.setter(Builder::totalSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIABLE_SIZE_IN_BYTES_FIELD, PUBLICLY_ACCESSIBLE_COUNT_FIELD, TOTAL_COUNT_FIELD, TOTAL_SIZE_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("classifiableSizeInBytes", CLASSIFIABLE_SIZE_IN_BYTES_FIELD);
            this.put("publiclyAccessibleCount", PUBLICLY_ACCESSIBLE_COUNT_FIELD);
            this.put("totalCount", TOTAL_COUNT_FIELD);
            this.put("totalSizeInBytes", TOTAL_SIZE_IN_BYTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long classifiableSizeInBytes;
    private final Long publiclyAccessibleCount;
    private final Long totalCount;
    private final Long totalSizeInBytes;

    private SensitivityAggregations(BuilderImpl builder) {
        this.classifiableSizeInBytes = builder.classifiableSizeInBytes;
        this.publiclyAccessibleCount = builder.publiclyAccessibleCount;
        this.totalCount = builder.totalCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
    }

    public final Long classifiableSizeInBytes() {
        return this.classifiableSizeInBytes;
    }

    public final Long publiclyAccessibleCount() {
        return this.publiclyAccessibleCount;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public final Long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessibleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitivityAggregations)) {
            return false;
        }
        SensitivityAggregations other = (SensitivityAggregations)obj;
        return Objects.equals(this.classifiableSizeInBytes(), other.classifiableSizeInBytes()) && Objects.equals(this.publiclyAccessibleCount(), other.publiclyAccessibleCount()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.totalSizeInBytes(), other.totalSizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"SensitivityAggregations").add("ClassifiableSizeInBytes", (Object)this.classifiableSizeInBytes()).add("PubliclyAccessibleCount", (Object)this.publiclyAccessibleCount()).add("TotalCount", (Object)this.totalCount()).add("TotalSizeInBytes", (Object)this.totalSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "classifiableSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.classifiableSizeInBytes()));
            }
            case "publiclyAccessibleCount": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessibleCount()));
            }
            case "totalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "totalSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.totalSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SensitivityAggregations, T> g) {
        return obj -> g.apply((SensitivityAggregations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long classifiableSizeInBytes;
        private Long publiclyAccessibleCount;
        private Long totalCount;
        private Long totalSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitivityAggregations model) {
            this.classifiableSizeInBytes(model.classifiableSizeInBytes);
            this.publiclyAccessibleCount(model.publiclyAccessibleCount);
            this.totalCount(model.totalCount);
            this.totalSizeInBytes(model.totalSizeInBytes);
        }

        public final Long getClassifiableSizeInBytes() {
            return this.classifiableSizeInBytes;
        }

        public final void setClassifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
        }

        @Override
        public final Builder classifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
            return this;
        }

        public final Long getPubliclyAccessibleCount() {
            return this.publiclyAccessibleCount;
        }

        public final void setPubliclyAccessibleCount(Long publiclyAccessibleCount) {
            this.publiclyAccessibleCount = publiclyAccessibleCount;
        }

        @Override
        public final Builder publiclyAccessibleCount(Long publiclyAccessibleCount) {
            this.publiclyAccessibleCount = publiclyAccessibleCount;
            return this;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return this.totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public SensitivityAggregations build() {
            return new SensitivityAggregations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SensitivityAggregations> {
        public Builder classifiableSizeInBytes(Long var1);

        public Builder publiclyAccessibleCount(Long var1);

        public Builder totalCount(Long var1);

        public Builder totalSizeInBytes(Long var1);
    }
}

