/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UnavailabilityReasonCode {
    OBJECT_EXCEEDS_SIZE_QUOTA("OBJECT_EXCEEDS_SIZE_QUOTA"),
    UNSUPPORTED_OBJECT_TYPE("UNSUPPORTED_OBJECT_TYPE"),
    UNSUPPORTED_FINDING_TYPE("UNSUPPORTED_FINDING_TYPE"),
    INVALID_CLASSIFICATION_RESULT("INVALID_CLASSIFICATION_RESULT"),
    OBJECT_UNAVAILABLE("OBJECT_UNAVAILABLE"),
    ACCOUNT_NOT_IN_ORGANIZATION("ACCOUNT_NOT_IN_ORGANIZATION"),
    MISSING_GET_MEMBER_PERMISSION("MISSING_GET_MEMBER_PERMISSION"),
    ROLE_TOO_PERMISSIVE("ROLE_TOO_PERMISSIVE"),
    MEMBER_ROLE_TOO_PERMISSIVE("MEMBER_ROLE_TOO_PERMISSIVE"),
    INVALID_RESULT_SIGNATURE("INVALID_RESULT_SIGNATURE"),
    RESULT_NOT_SIGNED("RESULT_NOT_SIGNED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnavailabilityReasonCode> VALUE_MAP;
    private final String value;

    private UnavailabilityReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UnavailabilityReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UnavailabilityReasonCode> knownValues() {
        EnumSet<UnavailabilityReasonCode> knownValues = EnumSet.allOf(UnavailabilityReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UnavailabilityReasonCode.class, UnavailabilityReasonCode::toString);
    }
}

