/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Cell;
import software.amazon.awssdk.services.macie2.model.CellsCopier;
import software.amazon.awssdk.services.macie2.model.Page;
import software.amazon.awssdk.services.macie2.model.PagesCopier;
import software.amazon.awssdk.services.macie2.model.Range;
import software.amazon.awssdk.services.macie2.model.RangesCopier;
import software.amazon.awssdk.services.macie2.model.Record;
import software.amazon.awssdk.services.macie2.model.RecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Occurrences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Occurrences> {
    private static final SdkField<List<Cell>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cells").getter(Occurrences.getter(Occurrences::cells)).setter(Occurrences.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Range>> LINE_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lineRanges").getter(Occurrences.getter(Occurrences::lineRanges)).setter(Occurrences.setter(Builder::lineRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Range>> OFFSET_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("offsetRanges").getter(Occurrences.getter(Occurrences::offsetRanges)).setter(Occurrences.setter(Builder::offsetRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Page>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pages").getter(Occurrences.getter(Occurrences::pages)).setter(Occurrences.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Page::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(Occurrences.getter(Occurrences::records)).setter(Occurrences.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD, LINE_RANGES_FIELD, OFFSET_RANGES_FIELD, PAGES_FIELD, RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cells", CELLS_FIELD);
            this.put("lineRanges", LINE_RANGES_FIELD);
            this.put("offsetRanges", OFFSET_RANGES_FIELD);
            this.put("pages", PAGES_FIELD);
            this.put("records", RECORDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Cell> cells;
    private final List<Range> lineRanges;
    private final List<Range> offsetRanges;
    private final List<Page> pages;
    private final List<Record> records;

    private Occurrences(BuilderImpl builder) {
        this.cells = builder.cells;
        this.lineRanges = builder.lineRanges;
        this.offsetRanges = builder.offsetRanges;
        this.pages = builder.pages;
        this.records = builder.records;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<Cell> cells() {
        return this.cells;
    }

    public final boolean hasLineRanges() {
        return this.lineRanges != null && !(this.lineRanges instanceof SdkAutoConstructList);
    }

    public final List<Range> lineRanges() {
        return this.lineRanges;
    }

    public final boolean hasOffsetRanges() {
        return this.offsetRanges != null && !(this.offsetRanges instanceof SdkAutoConstructList);
    }

    public final List<Range> offsetRanges() {
        return this.offsetRanges;
    }

    public final boolean hasPages() {
        return this.pages != null && !(this.pages instanceof SdkAutoConstructList);
    }

    public final List<Page> pages() {
        return this.pages;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<Record> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineRanges() ? this.lineRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOffsetRanges() ? this.offsetRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPages() ? this.pages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Occurrences)) {
            return false;
        }
        Occurrences other = (Occurrences)obj;
        return this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells()) && this.hasLineRanges() == other.hasLineRanges() && Objects.equals(this.lineRanges(), other.lineRanges()) && this.hasOffsetRanges() == other.hasOffsetRanges() && Objects.equals(this.offsetRanges(), other.offsetRanges()) && this.hasPages() == other.hasPages() && Objects.equals(this.pages(), other.pages()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records());
    }

    public final String toString() {
        return ToString.builder((String)"Occurrences").add("Cells", this.hasCells() ? this.cells() : null).add("LineRanges", this.hasLineRanges() ? this.lineRanges() : null).add("OffsetRanges", this.hasOffsetRanges() ? this.offsetRanges() : null).add("Pages", this.hasPages() ? this.pages() : null).add("Records", this.hasRecords() ? this.records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
            case "lineRanges": {
                return Optional.ofNullable(clazz.cast(this.lineRanges()));
            }
            case "offsetRanges": {
                return Optional.ofNullable(clazz.cast(this.offsetRanges()));
            }
            case "pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Occurrences, T> g) {
        return obj -> g.apply((Occurrences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Cell> cells = DefaultSdkAutoConstructList.getInstance();
        private List<Range> lineRanges = DefaultSdkAutoConstructList.getInstance();
        private List<Range> offsetRanges = DefaultSdkAutoConstructList.getInstance();
        private List<Page> pages = DefaultSdkAutoConstructList.getInstance();
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Occurrences model) {
            this.cells(model.cells);
            this.lineRanges(model.lineRanges);
            this.offsetRanges(model.offsetRanges);
            this.pages(model.pages);
            this.records(model.records);
        }

        public final List<Cell.Builder> getCells() {
            List<Cell.Builder> result = CellsCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCells(Collection<Cell.BuilderImpl> cells) {
            this.cells = CellsCopier.copyFromBuilder(cells);
        }

        @Override
        public final Builder cells(Collection<Cell> cells) {
            this.cells = CellsCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Cell ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<Cell.Builder> ... cells) {
            this.cells(Stream.of(cells).map(c -> (Cell)((Cell.Builder)Cell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getLineRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.lineRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineRanges(Collection<Range.BuilderImpl> lineRanges) {
            this.lineRanges = RangesCopier.copyFromBuilder(lineRanges);
        }

        @Override
        public final Builder lineRanges(Collection<Range> lineRanges) {
            this.lineRanges = RangesCopier.copy(lineRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineRanges(Range ... lineRanges) {
            this.lineRanges(Arrays.asList(lineRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineRanges(Consumer<Range.Builder> ... lineRanges) {
            this.lineRanges(Stream.of(lineRanges).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getOffsetRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.offsetRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOffsetRanges(Collection<Range.BuilderImpl> offsetRanges) {
            this.offsetRanges = RangesCopier.copyFromBuilder(offsetRanges);
        }

        @Override
        public final Builder offsetRanges(Collection<Range> offsetRanges) {
            this.offsetRanges = RangesCopier.copy(offsetRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offsetRanges(Range ... offsetRanges) {
            this.offsetRanges(Arrays.asList(offsetRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offsetRanges(Consumer<Range.Builder> ... offsetRanges) {
            this.offsetRanges(Stream.of(offsetRanges).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Page.Builder> getPages() {
            List<Page.Builder> result = PagesCopier.copyToBuilder(this.pages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPages(Collection<Page.BuilderImpl> pages) {
            this.pages = PagesCopier.copyFromBuilder(pages);
        }

        @Override
        public final Builder pages(Collection<Page> pages) {
            this.pages = PagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Page ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Consumer<Page.Builder> ... pages) {
            this.pages(Stream.of(pages).map(c -> (Page)((Page.Builder)Page.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Occurrences build() {
            return new Occurrences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Occurrences> {
        public Builder cells(Collection<Cell> var1);

        public Builder cells(Cell ... var1);

        public Builder cells(Consumer<Cell.Builder> ... var1);

        public Builder lineRanges(Collection<Range> var1);

        public Builder lineRanges(Range ... var1);

        public Builder lineRanges(Consumer<Range.Builder> ... var1);

        public Builder offsetRanges(Collection<Range> var1);

        public Builder offsetRanges(Range ... var1);

        public Builder offsetRanges(Consumer<Range.Builder> ... var1);

        public Builder pages(Collection<Page> var1);

        public Builder pages(Page ... var1);

        public Builder pages(Consumer<Page.Builder> ... var1);

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);
    }
}

