/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.ResourceStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceProfileResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetResourceProfileResponse> {
    private static final SdkField<Instant> PROFILE_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("profileUpdatedAt").getter(GetResourceProfileResponse.getter(GetResourceProfileResponse::profileUpdatedAt)).setter(GetResourceProfileResponse.setter(Builder::profileUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> SENSITIVITY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sensitivityScore").getter(GetResourceProfileResponse.getter(GetResourceProfileResponse::sensitivityScore)).setter(GetResourceProfileResponse.setter(Builder::sensitivityScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityScore").build()}).build();
    private static final SdkField<Boolean> SENSITIVITY_SCORE_OVERRIDDEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("sensitivityScoreOverridden").getter(GetResourceProfileResponse.getter(GetResourceProfileResponse::sensitivityScoreOverridden)).setter(GetResourceProfileResponse.setter(Builder::sensitivityScoreOverridden)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityScoreOverridden").build()}).build();
    private static final SdkField<ResourceStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(GetResourceProfileResponse.getter(GetResourceProfileResponse::statistics)).setter(GetResourceProfileResponse.setter(Builder::statistics)).constructor(ResourceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_UPDATED_AT_FIELD, SENSITIVITY_SCORE_FIELD, SENSITIVITY_SCORE_OVERRIDDEN_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("profileUpdatedAt", PROFILE_UPDATED_AT_FIELD);
            this.put("sensitivityScore", SENSITIVITY_SCORE_FIELD);
            this.put("sensitivityScoreOverridden", SENSITIVITY_SCORE_OVERRIDDEN_FIELD);
            this.put("statistics", STATISTICS_FIELD);
        }
    });
    private final Instant profileUpdatedAt;
    private final Integer sensitivityScore;
    private final Boolean sensitivityScoreOverridden;
    private final ResourceStatistics statistics;

    private GetResourceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileUpdatedAt = builder.profileUpdatedAt;
        this.sensitivityScore = builder.sensitivityScore;
        this.sensitivityScoreOverridden = builder.sensitivityScoreOverridden;
        this.statistics = builder.statistics;
    }

    public final Instant profileUpdatedAt() {
        return this.profileUpdatedAt;
    }

    public final Integer sensitivityScore() {
        return this.sensitivityScore;
    }

    public final Boolean sensitivityScoreOverridden() {
        return this.sensitivityScoreOverridden;
    }

    public final ResourceStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitivityScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitivityScoreOverridden());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceProfileResponse)) {
            return false;
        }
        GetResourceProfileResponse other = (GetResourceProfileResponse)((Object)obj);
        return Objects.equals(this.profileUpdatedAt(), other.profileUpdatedAt()) && Objects.equals(this.sensitivityScore(), other.sensitivityScore()) && Objects.equals(this.sensitivityScoreOverridden(), other.sensitivityScoreOverridden()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceProfileResponse").add("ProfileUpdatedAt", (Object)this.profileUpdatedAt()).add("SensitivityScore", (Object)this.sensitivityScore()).add("SensitivityScoreOverridden", (Object)this.sensitivityScoreOverridden()).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.profileUpdatedAt()));
            }
            case "sensitivityScore": {
                return Optional.ofNullable(clazz.cast(this.sensitivityScore()));
            }
            case "sensitivityScoreOverridden": {
                return Optional.ofNullable(clazz.cast(this.sensitivityScoreOverridden()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceProfileResponse, T> g) {
        return obj -> g.apply((GetResourceProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private Instant profileUpdatedAt;
        private Integer sensitivityScore;
        private Boolean sensitivityScoreOverridden;
        private ResourceStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceProfileResponse model) {
            super(model);
            this.profileUpdatedAt(model.profileUpdatedAt);
            this.sensitivityScore(model.sensitivityScore);
            this.sensitivityScoreOverridden(model.sensitivityScoreOverridden);
            this.statistics(model.statistics);
        }

        public final Instant getProfileUpdatedAt() {
            return this.profileUpdatedAt;
        }

        public final void setProfileUpdatedAt(Instant profileUpdatedAt) {
            this.profileUpdatedAt = profileUpdatedAt;
        }

        @Override
        public final Builder profileUpdatedAt(Instant profileUpdatedAt) {
            this.profileUpdatedAt = profileUpdatedAt;
            return this;
        }

        public final Integer getSensitivityScore() {
            return this.sensitivityScore;
        }

        public final void setSensitivityScore(Integer sensitivityScore) {
            this.sensitivityScore = sensitivityScore;
        }

        @Override
        public final Builder sensitivityScore(Integer sensitivityScore) {
            this.sensitivityScore = sensitivityScore;
            return this;
        }

        public final Boolean getSensitivityScoreOverridden() {
            return this.sensitivityScoreOverridden;
        }

        public final void setSensitivityScoreOverridden(Boolean sensitivityScoreOverridden) {
            this.sensitivityScoreOverridden = sensitivityScoreOverridden;
        }

        @Override
        public final Builder sensitivityScoreOverridden(Boolean sensitivityScoreOverridden) {
            this.sensitivityScoreOverridden = sensitivityScoreOverridden;
            return this;
        }

        public final ResourceStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(ResourceStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ResourceStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetResourceProfileResponse build() {
            return new GetResourceProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceProfileResponse> {
        public Builder profileUpdatedAt(Instant var1);

        public Builder sensitivityScore(Integer var1);

        public Builder sensitivityScoreOverridden(Boolean var1);

        public Builder statistics(ResourceStatistics var1);

        default public Builder statistics(Consumer<ResourceStatistics.Builder> statistics) {
            return this.statistics((ResourceStatistics)((ResourceStatistics.Builder)ResourceStatistics.builder().applyMutation(statistics)).build());
        }
    }
}

