/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.DetectedDataDetails;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.RevealRequestStatus;
import software.amazon.awssdk.services.macie2.model.SensitiveDataOccurrencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSensitiveDataOccurrencesResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetSensitiveDataOccurrencesResponse> {
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(GetSensitiveDataOccurrencesResponse.getter(GetSensitiveDataOccurrencesResponse::error)).setter(GetSensitiveDataOccurrencesResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<Map<String, List<DetectedDataDetails>>> SENSITIVE_DATA_OCCURRENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sensitiveDataOccurrences").getter(GetSensitiveDataOccurrencesResponse.getter(GetSensitiveDataOccurrencesResponse::sensitiveDataOccurrences)).setter(GetSensitiveDataOccurrencesResponse.setter(Builder::sensitiveDataOccurrences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveDataOccurrences").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectedDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSensitiveDataOccurrencesResponse.getter(GetSensitiveDataOccurrencesResponse::statusAsString)).setter(GetSensitiveDataOccurrencesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, SENSITIVE_DATA_OCCURRENCES_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("error", ERROR_FIELD);
            this.put("sensitiveDataOccurrences", SENSITIVE_DATA_OCCURRENCES_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String error;
    private final Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences;
    private final String status;

    private GetSensitiveDataOccurrencesResponse(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.sensitiveDataOccurrences = builder.sensitiveDataOccurrences;
        this.status = builder.status;
    }

    public final String error() {
        return this.error;
    }

    public final boolean hasSensitiveDataOccurrences() {
        return this.sensitiveDataOccurrences != null && !(this.sensitiveDataOccurrences instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences() {
        return this.sensitiveDataOccurrences;
    }

    public final RevealRequestStatus status() {
        return RevealRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSensitiveDataOccurrences() ? this.sensitiveDataOccurrences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitiveDataOccurrencesResponse)) {
            return false;
        }
        GetSensitiveDataOccurrencesResponse other = (GetSensitiveDataOccurrencesResponse)((Object)obj);
        return Objects.equals(this.error(), other.error()) && this.hasSensitiveDataOccurrences() == other.hasSensitiveDataOccurrences() && Objects.equals(this.sensitiveDataOccurrences(), other.sensitiveDataOccurrences()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSensitiveDataOccurrencesResponse").add("Error", (Object)this.error()).add("SensitiveDataOccurrences", this.hasSensitiveDataOccurrences() ? this.sensitiveDataOccurrences() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "sensitiveDataOccurrences": {
                return Optional.ofNullable(clazz.cast(this.sensitiveDataOccurrences()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSensitiveDataOccurrencesResponse, T> g) {
        return obj -> g.apply((GetSensitiveDataOccurrencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String error;
        private Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitiveDataOccurrencesResponse model) {
            super(model);
            this.error(model.error);
            this.sensitiveDataOccurrences(model.sensitiveDataOccurrences);
            this.status(model.status);
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Map<String, List<DetectedDataDetails.Builder>> getSensitiveDataOccurrences() {
            Map<String, List<DetectedDataDetails.Builder>> result = SensitiveDataOccurrencesCopier.copyToBuilder(this.sensitiveDataOccurrences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSensitiveDataOccurrences(Map<String, ? extends Collection<DetectedDataDetails.BuilderImpl>> sensitiveDataOccurrences) {
            this.sensitiveDataOccurrences = SensitiveDataOccurrencesCopier.copyFromBuilder(sensitiveDataOccurrences);
        }

        @Override
        public final Builder sensitiveDataOccurrences(Map<String, ? extends Collection<DetectedDataDetails>> sensitiveDataOccurrences) {
            this.sensitiveDataOccurrences = SensitiveDataOccurrencesCopier.copy(sensitiveDataOccurrences);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RevealRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetSensitiveDataOccurrencesResponse build() {
            return new GetSensitiveDataOccurrencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSensitiveDataOccurrencesResponse> {
        public Builder error(String var1);

        public Builder sensitiveDataOccurrences(Map<String, ? extends Collection<DetectedDataDetails>> var1);

        public Builder status(String var1);

        public Builder status(RevealRequestStatus var1);
    }
}

