/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ManagedDataIdentifierSelector {
    ALL("ALL"),
    EXCLUDE("EXCLUDE"),
    INCLUDE("INCLUDE"),
    NONE("NONE"),
    RECOMMENDED("RECOMMENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ManagedDataIdentifierSelector> VALUE_MAP;
    private final String value;

    private ManagedDataIdentifierSelector(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ManagedDataIdentifierSelector fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ManagedDataIdentifierSelector> knownValues() {
        EnumSet<ManagedDataIdentifierSelector> knownValues = EnumSet.allOf(ManagedDataIdentifierSelector.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ManagedDataIdentifierSelector.class, ManagedDataIdentifierSelector::toString);
    }
}

