/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.MatchingResource;
import software.amazon.awssdk.services.macie2.model.___listOfMatchingResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResourcesResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, SearchResourcesResponse> {
    private static final SdkField<List<MatchingResource>> MATCHING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchingResources").getter(SearchResourcesResponse.getter(SearchResourcesResponse::matchingResources)).setter(SearchResourcesResponse.setter(Builder::matchingResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchingResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchResourcesResponse.getter(SearchResourcesResponse::nextToken)).setter(SearchResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHING_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MatchingResource> matchingResources;
    private final String nextToken;

    private SearchResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.matchingResources = builder.matchingResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMatchingResources() {
        return this.matchingResources != null && !(this.matchingResources instanceof SdkAutoConstructList);
    }

    public final List<MatchingResource> matchingResources() {
        return this.matchingResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingResources() ? this.matchingResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesResponse)) {
            return false;
        }
        SearchResourcesResponse other = (SearchResourcesResponse)((Object)obj);
        return this.hasMatchingResources() == other.hasMatchingResources() && Objects.equals(this.matchingResources(), other.matchingResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResourcesResponse").add("MatchingResources", this.hasMatchingResources() ? this.matchingResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matchingResources": {
                return Optional.ofNullable(clazz.cast(this.matchingResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesResponse, T> g) {
        return obj -> g.apply((SearchResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<MatchingResource> matchingResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesResponse model) {
            super(model);
            this.matchingResources(model.matchingResources);
            this.nextToken(model.nextToken);
        }

        public final List<MatchingResource.Builder> getMatchingResources() {
            List<MatchingResource.Builder> result = ___listOfMatchingResourceCopier.copyToBuilder(this.matchingResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchingResources(Collection<MatchingResource.BuilderImpl> matchingResources) {
            this.matchingResources = ___listOfMatchingResourceCopier.copyFromBuilder(matchingResources);
        }

        @Override
        public final Builder matchingResources(Collection<MatchingResource> matchingResources) {
            this.matchingResources = ___listOfMatchingResourceCopier.copy(matchingResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingResources(MatchingResource ... matchingResources) {
            this.matchingResources(Arrays.asList(matchingResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingResources(Consumer<MatchingResource.Builder> ... matchingResources) {
            this.matchingResources(Stream.of(matchingResources).map(c -> (MatchingResource)((MatchingResource.Builder)MatchingResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchResourcesResponse> {
        public Builder matchingResources(Collection<MatchingResource> var1);

        public Builder matchingResources(MatchingResource ... var1);

        public Builder matchingResources(Consumer<MatchingResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

