/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.FindingsFilterListItem;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;

public class ListFindingsFiltersPublisher
implements SdkPublisher<ListFindingsFiltersResponse> {
    private final Macie2AsyncClient client;
    private final ListFindingsFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsFiltersPublisher(Macie2AsyncClient client, ListFindingsFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsFiltersPublisher(Macie2AsyncClient client, ListFindingsFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingsFilterListItem> findingsFilterListItems() {
        Function<ListFindingsFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingsFilterListItems() != null) {
                return response.findingsFilterListItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingsFiltersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingsFiltersResponseFetcher
    implements AsyncPageFetcher<ListFindingsFiltersResponse> {
        private ListFindingsFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsFiltersResponse> nextPage(ListFindingsFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsFiltersPublisher.this.client.listFindingsFilters(ListFindingsFiltersPublisher.this.firstRequest);
            }
            return ListFindingsFiltersPublisher.this.client.listFindingsFilters((ListFindingsFiltersRequest)((Object)ListFindingsFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

