/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.macie2.DefaultMacie2BaseClientBuilder;
import software.amazon.awssdk.services.macie2.DefaultMacie2Client;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.Macie2ClientBuilder;
import software.amazon.awssdk.services.macie2.Macie2ServiceClientConfiguration;
import software.amazon.awssdk.services.macie2.endpoints.Macie2EndpointProvider;

@SdkInternalApi
final class DefaultMacie2ClientBuilder
extends DefaultMacie2BaseClientBuilder<Macie2ClientBuilder, Macie2Client>
implements Macie2ClientBuilder {
    DefaultMacie2ClientBuilder() {
    }

    @Override
    public DefaultMacie2ClientBuilder endpointProvider(Macie2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Macie2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMacie2ClientBuilder.validateClientOptions(clientConfiguration);
        Macie2ServiceClientConfiguration serviceClientConfiguration = Macie2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultMacie2Client(serviceClientConfiguration, clientConfiguration);
    }
}

