/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPausedDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPausedDetails> {
    private static final SdkField<Instant> JOB_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobExpiresAt").getter(UserPausedDetails.getter(UserPausedDetails::jobExpiresAt)).setter(UserPausedDetails.setter(Builder::jobExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_IMMINENT_EXPIRATION_HEALTH_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobImminentExpirationHealthEventArn").getter(UserPausedDetails.getter(UserPausedDetails::jobImminentExpirationHealthEventArn)).setter(UserPausedDetails.setter(Builder::jobImminentExpirationHealthEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobImminentExpirationHealthEventArn").build()}).build();
    private static final SdkField<Instant> JOB_PAUSED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobPausedAt").getter(UserPausedDetails.getter(UserPausedDetails::jobPausedAt)).setter(UserPausedDetails.setter(Builder::jobPausedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobPausedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_EXPIRES_AT_FIELD, JOB_IMMINENT_EXPIRATION_HEALTH_EVENT_ARN_FIELD, JOB_PAUSED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant jobExpiresAt;
    private final String jobImminentExpirationHealthEventArn;
    private final Instant jobPausedAt;

    private UserPausedDetails(BuilderImpl builder) {
        this.jobExpiresAt = builder.jobExpiresAt;
        this.jobImminentExpirationHealthEventArn = builder.jobImminentExpirationHealthEventArn;
        this.jobPausedAt = builder.jobPausedAt;
    }

    public final Instant jobExpiresAt() {
        return this.jobExpiresAt;
    }

    public final String jobImminentExpirationHealthEventArn() {
        return this.jobImminentExpirationHealthEventArn;
    }

    public final Instant jobPausedAt() {
        return this.jobPausedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobImminentExpirationHealthEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobPausedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPausedDetails)) {
            return false;
        }
        UserPausedDetails other = (UserPausedDetails)obj;
        return Objects.equals(this.jobExpiresAt(), other.jobExpiresAt()) && Objects.equals(this.jobImminentExpirationHealthEventArn(), other.jobImminentExpirationHealthEventArn()) && Objects.equals(this.jobPausedAt(), other.jobPausedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UserPausedDetails").add("JobExpiresAt", (Object)this.jobExpiresAt()).add("JobImminentExpirationHealthEventArn", (Object)this.jobImminentExpirationHealthEventArn()).add("JobPausedAt", (Object)this.jobPausedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.jobExpiresAt()));
            }
            case "jobImminentExpirationHealthEventArn": {
                return Optional.ofNullable(clazz.cast(this.jobImminentExpirationHealthEventArn()));
            }
            case "jobPausedAt": {
                return Optional.ofNullable(clazz.cast(this.jobPausedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPausedDetails, T> g) {
        return obj -> g.apply((UserPausedDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant jobExpiresAt;
        private String jobImminentExpirationHealthEventArn;
        private Instant jobPausedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPausedDetails model) {
            this.jobExpiresAt(model.jobExpiresAt);
            this.jobImminentExpirationHealthEventArn(model.jobImminentExpirationHealthEventArn);
            this.jobPausedAt(model.jobPausedAt);
        }

        public final Instant getJobExpiresAt() {
            return this.jobExpiresAt;
        }

        public final void setJobExpiresAt(Instant jobExpiresAt) {
            this.jobExpiresAt = jobExpiresAt;
        }

        @Override
        public final Builder jobExpiresAt(Instant jobExpiresAt) {
            this.jobExpiresAt = jobExpiresAt;
            return this;
        }

        public final String getJobImminentExpirationHealthEventArn() {
            return this.jobImminentExpirationHealthEventArn;
        }

        public final void setJobImminentExpirationHealthEventArn(String jobImminentExpirationHealthEventArn) {
            this.jobImminentExpirationHealthEventArn = jobImminentExpirationHealthEventArn;
        }

        @Override
        public final Builder jobImminentExpirationHealthEventArn(String jobImminentExpirationHealthEventArn) {
            this.jobImminentExpirationHealthEventArn = jobImminentExpirationHealthEventArn;
            return this;
        }

        public final Instant getJobPausedAt() {
            return this.jobPausedAt;
        }

        public final void setJobPausedAt(Instant jobPausedAt) {
            this.jobPausedAt = jobPausedAt;
        }

        @Override
        public final Builder jobPausedAt(Instant jobPausedAt) {
            this.jobPausedAt = jobPausedAt;
            return this;
        }

        public UserPausedDetails build() {
            return new UserPausedDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPausedDetails> {
        public Builder jobExpiresAt(Instant var1);

        public Builder jobImminentExpirationHealthEventArn(String var1);

        public Builder jobPausedAt(Instant var1);
    }
}

