/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;

public class ListCustomDataIdentifiersPublisher
implements SdkPublisher<ListCustomDataIdentifiersResponse> {
    private final Macie2AsyncClient client;
    private final ListCustomDataIdentifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomDataIdentifiersPublisher(Macie2AsyncClient client, ListCustomDataIdentifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomDataIdentifiersPublisher(Macie2AsyncClient client, ListCustomDataIdentifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomDataIdentifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomDataIdentifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomDataIdentifierSummary> items() {
        Function<ListCustomDataIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomDataIdentifiersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomDataIdentifiersResponseFetcher
    implements AsyncPageFetcher<ListCustomDataIdentifiersResponse> {
        private ListCustomDataIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomDataIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomDataIdentifiersResponse> nextPage(ListCustomDataIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListCustomDataIdentifiersPublisher.this.client.listCustomDataIdentifiers(ListCustomDataIdentifiersPublisher.this.firstRequest);
            }
            return ListCustomDataIdentifiersPublisher.this.client.listCustomDataIdentifiers((ListCustomDataIdentifiersRequest)((Object)ListCustomDataIdentifiersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

