/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.JobComparator;
import software.amazon.awssdk.services.macie2.model.SimpleCriterionKeyForJob;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimpleCriterionForJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimpleCriterionForJob> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparator").getter(SimpleCriterionForJob.getter(SimpleCriterionForJob::comparatorAsString)).setter(SimpleCriterionForJob.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(SimpleCriterionForJob.getter(SimpleCriterionForJob::keyAsString)).setter(SimpleCriterionForJob.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(SimpleCriterionForJob.getter(SimpleCriterionForJob::values)).setter(SimpleCriterionForJob.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparator;
    private final String key;
    private final List<String> values;

    private SimpleCriterionForJob(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.values = builder.values;
    }

    public final JobComparator comparator() {
        return JobComparator.fromValue(this.comparator);
    }

    public final String comparatorAsString() {
        return this.comparator;
    }

    public final SimpleCriterionKeyForJob key() {
        return SimpleCriterionKeyForJob.fromValue(this.key);
    }

    public final String keyAsString() {
        return this.key;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleCriterionForJob)) {
            return false;
        }
        SimpleCriterionForJob other = (SimpleCriterionForJob)obj;
        return Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.keyAsString(), other.keyAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"SimpleCriterionForJob").add("Comparator", (Object)this.comparatorAsString()).add("Key", (Object)this.keyAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleCriterionForJob, T> g) {
        return obj -> g.apply((SimpleCriterionForJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparator;
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleCriterionForJob model) {
            this.comparator(model.comparator);
            this.key(model.key);
            this.values(model.values);
        }

        public final String getComparator() {
            return this.comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(SimpleCriterionKeyForJob key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
        }

        public SimpleCriterionForJob build() {
            return new SimpleCriterionForJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimpleCriterionForJob> {
        public Builder comparator(String var1);

        public Builder comparator(JobComparator var1);

        public Builder key(String var1);

        public Builder key(SimpleCriterionKeyForJob var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

