/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiCallDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiCallDetails> {
    private static final SdkField<String> API_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("api").getter(ApiCallDetails.getter(ApiCallDetails::api)).setter(ApiCallDetails.setter(Builder::api)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()}).build();
    private static final SdkField<String> API_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiServiceName").getter(ApiCallDetails.getter(ApiCallDetails::apiServiceName)).setter(ApiCallDetails.setter(Builder::apiServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiServiceName").build()}).build();
    private static final SdkField<Instant> FIRST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstSeen").getter(ApiCallDetails.getter(ApiCallDetails::firstSeen)).setter(ApiCallDetails.setter(Builder::firstSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSeen").getter(ApiCallDetails.getter(ApiCallDetails::lastSeen)).setter(ApiCallDetails.setter(Builder::lastSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, API_SERVICE_NAME_FIELD, FIRST_SEEN_FIELD, LAST_SEEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String api;
    private final String apiServiceName;
    private final Instant firstSeen;
    private final Instant lastSeen;

    private ApiCallDetails(BuilderImpl builder) {
        this.api = builder.api;
        this.apiServiceName = builder.apiServiceName;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
    }

    public final String api() {
        return this.api;
    }

    public final String apiServiceName() {
        return this.apiServiceName;
    }

    public final Instant firstSeen() {
        return this.firstSeen;
    }

    public final Instant lastSeen() {
        return this.lastSeen;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.api());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeen());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiCallDetails)) {
            return false;
        }
        ApiCallDetails other = (ApiCallDetails)obj;
        return Objects.equals(this.api(), other.api()) && Objects.equals(this.apiServiceName(), other.apiServiceName()) && Objects.equals(this.firstSeen(), other.firstSeen()) && Objects.equals(this.lastSeen(), other.lastSeen());
    }

    public final String toString() {
        return ToString.builder((String)"ApiCallDetails").add("Api", (Object)this.api()).add("ApiServiceName", (Object)this.apiServiceName()).add("FirstSeen", (Object)this.firstSeen()).add("LastSeen", (Object)this.lastSeen()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "api": {
                return Optional.ofNullable(clazz.cast(this.api()));
            }
            case "apiServiceName": {
                return Optional.ofNullable(clazz.cast(this.apiServiceName()));
            }
            case "firstSeen": {
                return Optional.ofNullable(clazz.cast(this.firstSeen()));
            }
            case "lastSeen": {
                return Optional.ofNullable(clazz.cast(this.lastSeen()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiCallDetails, T> g) {
        return obj -> g.apply((ApiCallDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String api;
        private String apiServiceName;
        private Instant firstSeen;
        private Instant lastSeen;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiCallDetails model) {
            this.api(model.api);
            this.apiServiceName(model.apiServiceName);
            this.firstSeen(model.firstSeen);
            this.lastSeen(model.lastSeen);
        }

        public final String getApi() {
            return this.api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        public final String getApiServiceName() {
            return this.apiServiceName;
        }

        @Override
        public final Builder apiServiceName(String apiServiceName) {
            this.apiServiceName = apiServiceName;
            return this;
        }

        public final void setApiServiceName(String apiServiceName) {
            this.apiServiceName = apiServiceName;
        }

        public final Instant getFirstSeen() {
            return this.firstSeen;
        }

        @Override
        public final Builder firstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final void setFirstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
        }

        public final Instant getLastSeen() {
            return this.lastSeen;
        }

        @Override
        public final Builder lastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public final void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        public ApiCallDetails build() {
            return new ApiCallDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiCallDetails> {
        public Builder api(String var1);

        public Builder apiServiceName(String var1);

        public Builder firstSeen(Instant var1);

        public Builder lastSeen(Instant var1);
    }
}

