/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum UserIdentityType {
    ASSUMED_ROLE("AssumedRole"),
    IAM_USER("IAMUser"),
    FEDERATED_USER("FederatedUser"),
    ROOT("Root"),
    AWS_ACCOUNT("AWSAccount"),
    AWS_SERVICE("AWSService"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private UserIdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserIdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(UserIdentityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserIdentityType> knownValues() {
        return Stream.of(UserIdentityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

