/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClassificationJobRequest extends Macie2Request implements
        ToCopyableBuilder<CreateClassificationJobRequest.Builder, CreateClassificationJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateClassificationJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customDataIdentifierIds")
            .getter(getter(CreateClassificationJobRequest::customDataIdentifierIds))
            .setter(setter(Builder::customDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateClassificationJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("initialRun").getter(getter(CreateClassificationJobRequest::initialRun))
            .setter(setter(Builder::initialRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(CreateClassificationJobRequest::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateClassificationJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField
            .<S3JobDefinition> builder(MarshallingType.SDK_POJO).memberName("s3JobDefinition")
            .getter(getter(CreateClassificationJobRequest::s3JobDefinition)).setter(setter(Builder::s3JobDefinition))
            .constructor(S3JobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()).build();

    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("samplingPercentage").getter(getter(CreateClassificationJobRequest::samplingPercentage))
            .setter(setter(Builder::samplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build())
            .build();

    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField
            .<JobScheduleFrequency> builder(MarshallingType.SDK_POJO).memberName("scheduleFrequency")
            .getter(getter(CreateClassificationJobRequest::scheduleFrequency)).setter(setter(Builder::scheduleFrequency))
            .constructor(JobScheduleFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClassificationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_TYPE_FIELD, NAME_FIELD,
            S3_JOB_DEFINITION_FIELD, SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final List<String> customDataIdentifierIds;

    private final String description;

    private final Boolean initialRun;

    private final String jobType;

    private final String name;

    private final S3JobDefinition s3JobDefinition;

    private final Integer samplingPercentage;

    private final JobScheduleFrequency scheduleFrequency;

    private final Map<String, String> tags;

    private CreateClassificationJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobType = builder.jobType;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the CustomDataIdentifierIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCustomDataIdentifierIds() {
        return customDataIdentifierIds != null && !(customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom data identifiers to use for data analysis and classification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomDataIdentifierIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom data identifiers to use for data analysis and classification.
     */
    public final List<String> customDataIdentifierIds() {
        return customDataIdentifierIds;
    }

    /**
     * <p>
     * A custom description of the job. The description can contain as many as 200 characters.
     * </p>
     * 
     * @return A custom description of the job. The description can contain as many as 200 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     * </p>
     * 
     * @return Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     */
    public final Boolean initialRun() {
        return initialRun;
    }

    /**
     * <p>
     * The schedule for running the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
     * property.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     * scheduleFrequency property to define the recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
     *         scheduleFrequency property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     *         scheduleFrequency property to define the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The schedule for running the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
     * property.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     * scheduleFrequency property to define the recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
     *         scheduleFrequency property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     *         scheduleFrequency property to define the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * A custom name for the job. The name can contain as many as 500 characters.
     * </p>
     * 
     * @return A custom name for the job. The name can contain as many as 500 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     * </p>
     * 
     * @return The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    public final S3JobDefinition s3JobDefinition() {
        return s3JobDefinition;
    }

    /**
     * <p>
     * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of
     * eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to
     * analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     * </p>
     * 
     * @return The sampling depth, as a percentage, to apply when processing objects. This value determines the
     *         percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie
     *         selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in
     *         those objects.
     */
    public final Integer samplingPercentage() {
        return samplingPercentage;
    }

    /**
     * <p>
     * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and
     * set the value for the jobType property to ONE_TIME.
     * </p>
     * 
     * @return The recurrence pattern for running the job. To run the job only once, don't specify a value for this
     *         property and set the value for the jobType property to ONE_TIME.
     */
    public final JobScheduleFrequency scheduleFrequency() {
        return scheduleFrequency;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the job.
     * </p>
     * <p>
     * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum
     * length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the job.</p>
     *         <p>
     *         A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
     *         maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassificationJobRequest)) {
            return false;
        }
        CreateClassificationJobRequest other = (CreateClassificationJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && hasCustomDataIdentifierIds() == other.hasCustomDataIdentifierIds()
                && Objects.equals(customDataIdentifierIds(), other.customDataIdentifierIds())
                && Objects.equals(description(), other.description()) && Objects.equals(initialRun(), other.initialRun())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(s3JobDefinition(), other.s3JobDefinition())
                && Objects.equals(samplingPercentage(), other.samplingPercentage())
                && Objects.equals(scheduleFrequency(), other.scheduleFrequency()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClassificationJobRequest").add("ClientToken", clientToken())
                .add("CustomDataIdentifierIds", hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null)
                .add("Description", description()).add("InitialRun", initialRun()).add("JobType", jobTypeAsString())
                .add("Name", name()).add("S3JobDefinition", s3JobDefinition()).add("SamplingPercentage", samplingPercentage())
                .add("ScheduleFrequency", scheduleFrequency()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "customDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(customDataIdentifierIds()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "initialRun":
            return Optional.ofNullable(clazz.cast(initialRun()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3JobDefinition":
            return Optional.ofNullable(clazz.cast(s3JobDefinition()));
        case "samplingPercentage":
            return Optional.ofNullable(clazz.cast(samplingPercentage()));
        case "scheduleFrequency":
            return Optional.ofNullable(clazz.cast(scheduleFrequency()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClassificationJobRequest, T> g) {
        return obj -> g.apply((CreateClassificationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClassificationJobRequest> {
        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The custom data identifiers to use for data analysis and classification.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        The custom data identifiers to use for data analysis and classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds);

        /**
         * <p>
         * The custom data identifiers to use for data analysis and classification.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        The custom data identifiers to use for data analysis and classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(String... customDataIdentifierIds);

        /**
         * <p>
         * A custom description of the job. The description can contain as many as 200 characters.
         * </p>
         * 
         * @param description
         *        A custom description of the job. The description can contain as many as 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
         * </p>
         * 
         * @param initialRun
         *        Specifies whether to analyze all existing, eligible objects immediately after the job is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialRun(Boolean initialRun);

        /**
         * <p>
         * The schedule for running the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         * scheduleFrequency property to define the recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
         *        scheduleFrequency property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         *        scheduleFrequency property to define the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The schedule for running the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         * scheduleFrequency property to define the recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
         *        scheduleFrequency property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         *        scheduleFrequency property to define the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * A custom name for the job. The name can contain as many as 500 characters.
         * </p>
         * 
         * @param name
         *        A custom name for the job. The name can contain as many as 500 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * 
         * @param s3JobDefinition
         *        The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JobDefinition(S3JobDefinition s3JobDefinition);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link S3JobDefinition.Builder} avoiding the need to
         * create one manually via {@link S3JobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3JobDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #s3JobDefinition(S3JobDefinition)}.
         * 
         * @param s3JobDefinition
         *        a consumer that will call methods on {@link S3JobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JobDefinition(S3JobDefinition)
         */
        default Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return s3JobDefinition(S3JobDefinition.builder().applyMutation(s3JobDefinition).build());
        }

        /**
         * <p>
         * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage
         * of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects
         * to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
         * </p>
         * 
         * @param samplingPercentage
         *        The sampling depth, as a percentage, to apply when processing objects. This value determines the
         *        percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie
         *        selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in
         *        those objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingPercentage(Integer samplingPercentage);

        /**
         * <p>
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property
         * and set the value for the jobType property to ONE_TIME.
         * </p>
         * 
         * @param scheduleFrequency
         *        The recurrence pattern for running the job. To run the job only once, don't specify a value for this
         *        property and set the value for the jobType property to ONE_TIME.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency);

        /**
         * <p>
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property
         * and set the value for the jobType property to ONE_TIME.
         * </p>
         * This is a convenience that creates an instance of the {@link JobScheduleFrequency.Builder} avoiding the need
         * to create one manually via {@link JobScheduleFrequency#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobScheduleFrequency.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleFrequency(JobScheduleFrequency)}.
         * 
         * @param scheduleFrequency
         *        a consumer that will call methods on {@link JobScheduleFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleFrequency(JobScheduleFrequency)
         */
        default Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return scheduleFrequency(JobScheduleFrequency.builder().applyMutation(scheduleFrequency).build());
        }

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the job.
         * </p>
         * <p>
         * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum
         * length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the job.</p>
         *        <p>
         *        A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
         *        maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String clientToken;

        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean initialRun;

        private String jobType;

        private String name;

        private S3JobDefinition s3JobDefinition;

        private Integer samplingPercentage;

        private JobScheduleFrequency scheduleFrequency;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassificationJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            customDataIdentifierIds(model.customDataIdentifierIds);
            description(model.description);
            initialRun(model.initialRun);
            jobType(model.jobType);
            name(model.name);
            s3JobDefinition(model.s3JobDefinition);
            samplingPercentage(model.samplingPercentage);
            scheduleFrequency(model.scheduleFrequency);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            if (customDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return customDataIdentifierIds;
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String... customDataIdentifierIds) {
            customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getInitialRun() {
            return initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return s3JobDefinition != null ? s3JobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        public final Integer getSamplingPercentage() {
            return samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return scheduleFrequency != null ? scheduleFrequency.toBuilder() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClassificationJobRequest build() {
            return new CreateClassificationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
