/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptInvitationRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, AcceptInvitationRequest> {
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invitationId").getter(AcceptInvitationRequest.getter(AcceptInvitationRequest::invitationId)).setter(AcceptInvitationRequest.setter(Builder::invitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()}).build();
    private static final SdkField<String> MASTER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterAccount").getter(AcceptInvitationRequest.getter(AcceptInvitationRequest::masterAccount)).setter(AcceptInvitationRequest.setter(Builder::masterAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATION_ID_FIELD, MASTER_ACCOUNT_FIELD));
    private final String invitationId;
    private final String masterAccount;

    private AcceptInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.invitationId = builder.invitationId;
        this.masterAccount = builder.masterAccount;
    }

    public final String invitationId() {
        return this.invitationId;
    }

    public final String masterAccount() {
        return this.masterAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInvitationRequest)) {
            return false;
        }
        AcceptInvitationRequest other = (AcceptInvitationRequest)((Object)obj);
        return Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.masterAccount(), other.masterAccount());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptInvitationRequest").add("InvitationId", (Object)this.invitationId()).add("MasterAccount", (Object)this.masterAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
            case "masterAccount": {
                return Optional.ofNullable(clazz.cast(this.masterAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptInvitationRequest, T> g) {
        return obj -> g.apply((AcceptInvitationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String invitationId;
        private String masterAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInvitationRequest model) {
            super(model);
            this.invitationId(model.invitationId);
            this.masterAccount(model.masterAccount);
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getMasterAccount() {
            return this.masterAccount;
        }

        @Override
        public final Builder masterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
            return this;
        }

        public final void setMasterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInvitationRequest build() {
            return new AcceptInvitationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptInvitationRequest> {
        public Builder invitationId(String var1);

        public Builder masterAccount(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

