/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.BucketPublicAccess;
import software.amazon.awssdk.services.macie2.model.KeyValuePair;
import software.amazon.awssdk.services.macie2.model.KeyValuePairListCopier;
import software.amazon.awssdk.services.macie2.model.S3BucketOwner;
import software.amazon.awssdk.services.macie2.model.ServerSideEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Bucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Bucket> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Bucket.getter(S3Bucket::arn)).setter(S3Bucket.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(S3Bucket.getter(S3Bucket::createdAt)).setter(S3Bucket.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ServerSideEncryption> DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3Bucket.getter(S3Bucket::defaultServerSideEncryption)).setter(S3Bucket.setter(Builder::defaultServerSideEncryption)).constructor(ServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultServerSideEncryption").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Bucket.getter(S3Bucket::name)).setter(S3Bucket.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<S3BucketOwner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3Bucket.getter(S3Bucket::owner)).setter(S3Bucket.setter(Builder::owner)).constructor(S3BucketOwner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<BucketPublicAccess> PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3Bucket.getter(S3Bucket::publicAccess)).setter(S3Bucket.setter(Builder::publicAccess)).constructor(BucketPublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()}).build();
    private static final SdkField<List<KeyValuePair>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(S3Bucket.getter(S3Bucket::tags)).setter(S3Bucket.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD, NAME_FIELD, OWNER_FIELD, PUBLIC_ACCESS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final ServerSideEncryption defaultServerSideEncryption;
    private final String name;
    private final S3BucketOwner owner;
    private final BucketPublicAccess publicAccess;
    private final List<KeyValuePair> tags;

    private S3Bucket(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.defaultServerSideEncryption = builder.defaultServerSideEncryption;
        this.name = builder.name;
        this.owner = builder.owner;
        this.publicAccess = builder.publicAccess;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ServerSideEncryption defaultServerSideEncryption() {
        return this.defaultServerSideEncryption;
    }

    public String name() {
        return this.name;
    }

    public S3BucketOwner owner() {
        return this.owner;
    }

    public BucketPublicAccess publicAccess() {
        return this.publicAccess;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultServerSideEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.defaultServerSideEncryption(), other.defaultServerSideEncryption()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.publicAccess(), other.publicAccess()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"S3Bucket").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("DefaultServerSideEncryption", (Object)this.defaultServerSideEncryption()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("PublicAccess", (Object)this.publicAccess()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "defaultServerSideEncryption": {
                return Optional.ofNullable(clazz.cast(this.defaultServerSideEncryption()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "publicAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAccess()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Bucket, T> g) {
        return obj -> g.apply((S3Bucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private ServerSideEncryption defaultServerSideEncryption;
        private String name;
        private S3BucketOwner owner;
        private BucketPublicAccess publicAccess;
        private List<KeyValuePair> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3Bucket model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.defaultServerSideEncryption(model.defaultServerSideEncryption);
            this.name(model.name);
            this.owner(model.owner);
            this.publicAccess(model.publicAccess);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ServerSideEncryption.Builder getDefaultServerSideEncryption() {
            return this.defaultServerSideEncryption != null ? this.defaultServerSideEncryption.toBuilder() : null;
        }

        @Override
        public final Builder defaultServerSideEncryption(ServerSideEncryption defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption;
            return this;
        }

        public final void setDefaultServerSideEncryption(ServerSideEncryption.BuilderImpl defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption != null ? defaultServerSideEncryption.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final S3BucketOwner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(S3BucketOwner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(S3BucketOwner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final BucketPublicAccess.Builder getPublicAccess() {
            return this.publicAccess != null ? this.publicAccess.toBuilder() : null;
        }

        @Override
        public final Builder publicAccess(BucketPublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final void setPublicAccess(BucketPublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        public final Collection<KeyValuePair.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<KeyValuePair> tags) {
            this.tags = KeyValuePairListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(KeyValuePair ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<KeyValuePair.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<KeyValuePair.BuilderImpl> tags) {
            this.tags = KeyValuePairListCopier.copyFromBuilder(tags);
        }

        public S3Bucket build() {
            return new S3Bucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Bucket> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder defaultServerSideEncryption(ServerSideEncryption var1);

        default public Builder defaultServerSideEncryption(Consumer<ServerSideEncryption.Builder> defaultServerSideEncryption) {
            return this.defaultServerSideEncryption((ServerSideEncryption)((ServerSideEncryption.Builder)ServerSideEncryption.builder().applyMutation(defaultServerSideEncryption)).build());
        }

        public Builder name(String var1);

        public Builder owner(S3BucketOwner var1);

        default public Builder owner(Consumer<S3BucketOwner.Builder> owner) {
            return this.owner((S3BucketOwner)((S3BucketOwner.Builder)S3BucketOwner.builder().applyMutation(owner)).build());
        }

        public Builder publicAccess(BucketPublicAccess var1);

        default public Builder publicAccess(Consumer<BucketPublicAccess.Builder> publicAccess) {
            return this.publicAccess((BucketPublicAccess)((BucketPublicAccess.Builder)BucketPublicAccess.builder().applyMutation(publicAccess)).build());
        }

        public Builder tags(Collection<KeyValuePair> var1);

        public Builder tags(KeyValuePair ... var1);

        public Builder tags(Consumer<KeyValuePair.Builder> ... var1);
    }
}

