/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Finding;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.___listOfFindingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetFindingsResponse> {
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFindingsResponse.getter(GetFindingsResponse::findings)).setter(GetFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Finding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD));
    private final List<Finding> findings;

    private GetFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
    }

    public boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public List<Finding> findings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.findings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsResponse)) {
            return false;
        }
        GetFindingsResponse other = (GetFindingsResponse)((Object)obj);
        return Objects.equals(this.findings(), other.findings());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsResponse").add("Findings", this.findings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsResponse, T> g) {
        return obj -> g.apply((GetFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsResponse model) {
            super(model);
            this.findings(model.findings);
        }

        public final Collection<Finding.Builder> getFindings() {
            return this.findings != null ? (Collection)this.findings.stream().map(Finding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = ___listOfFindingCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = ___listOfFindingCopier.copyFromBuilder(findings);
        }

        @Override
        public GetFindingsResponse build() {
            return new GetFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsResponse> {
        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);
    }
}

