/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a session that was created for an entity who performed an action by using temporary
 * security credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionContext implements SdkPojo, Serializable, ToCopyableBuilder<SessionContext.Builder, SessionContext> {
    private static final SdkField<SessionContextAttributes> ATTRIBUTES_FIELD = SdkField
            .<SessionContextAttributes> builder(MarshallingType.SDK_POJO).getter(getter(SessionContext::attributes))
            .setter(setter(Builder::attributes)).constructor(SessionContextAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<SessionIssuer> SESSION_ISSUER_FIELD = SdkField
            .<SessionIssuer> builder(MarshallingType.SDK_POJO).getter(getter(SessionContext::sessionIssuer))
            .setter(setter(Builder::sessionIssuer)).constructor(SessionIssuer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionIssuer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            SESSION_ISSUER_FIELD));

    private static final long serialVersionUID = 1L;

    private final SessionContextAttributes attributes;

    private final SessionIssuer sessionIssuer;

    private SessionContext(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.sessionIssuer = builder.sessionIssuer;
    }

    /**
     * <p>
     * The date and time when the credentials were issued, and whether the credentials were authenticated with a
     * multi-factor authentication (MFA) device.
     * </p>
     * 
     * @return The date and time when the credentials were issued, and whether the credentials were authenticated with a
     *         multi-factor authentication (MFA) device.
     */
    public SessionContextAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * The source and type of credentials that the entity obtained.
     * </p>
     * 
     * @return The source and type of credentials that the entity obtained.
     */
    public SessionIssuer sessionIssuer() {
        return sessionIssuer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIssuer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionContext)) {
            return false;
        }
        SessionContext other = (SessionContext) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(sessionIssuer(), other.sessionIssuer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SessionContext").add("Attributes", attributes()).add("SessionIssuer", sessionIssuer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "sessionIssuer":
            return Optional.ofNullable(clazz.cast(sessionIssuer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionContext, T> g) {
        return obj -> g.apply((SessionContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionContext> {
        /**
         * <p>
         * The date and time when the credentials were issued, and whether the credentials were authenticated with a
         * multi-factor authentication (MFA) device.
         * </p>
         * 
         * @param attributes
         *        The date and time when the credentials were issued, and whether the credentials were authenticated
         *        with a multi-factor authentication (MFA) device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(SessionContextAttributes attributes);

        /**
         * <p>
         * The date and time when the credentials were issued, and whether the credentials were authenticated with a
         * multi-factor authentication (MFA) device.
         * </p>
         * This is a convenience that creates an instance of the {@link SessionContextAttributes.Builder} avoiding the
         * need to create one manually via {@link SessionContextAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionContextAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(SessionContextAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link SessionContextAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(SessionContextAttributes)
         */
        default Builder attributes(Consumer<SessionContextAttributes.Builder> attributes) {
            return attributes(SessionContextAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * The source and type of credentials that the entity obtained.
         * </p>
         * 
         * @param sessionIssuer
         *        The source and type of credentials that the entity obtained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIssuer(SessionIssuer sessionIssuer);

        /**
         * <p>
         * The source and type of credentials that the entity obtained.
         * </p>
         * This is a convenience that creates an instance of the {@link SessionIssuer.Builder} avoiding the need to
         * create one manually via {@link SessionIssuer#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionIssuer.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionIssuer(SessionIssuer)}.
         * 
         * @param sessionIssuer
         *        a consumer that will call methods on {@link SessionIssuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionIssuer(SessionIssuer)
         */
        default Builder sessionIssuer(Consumer<SessionIssuer.Builder> sessionIssuer) {
            return sessionIssuer(SessionIssuer.builder().applyMutation(sessionIssuer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SessionContextAttributes attributes;

        private SessionIssuer sessionIssuer;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionContext model) {
            attributes(model.attributes);
            sessionIssuer(model.sessionIssuer);
        }

        public final SessionContextAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        @Override
        public final Builder attributes(SessionContextAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final void setAttributes(SessionContextAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        public final SessionIssuer.Builder getSessionIssuer() {
            return sessionIssuer != null ? sessionIssuer.toBuilder() : null;
        }

        @Override
        public final Builder sessionIssuer(SessionIssuer sessionIssuer) {
            this.sessionIssuer = sessionIssuer;
            return this;
        }

        public final void setSessionIssuer(SessionIssuer.BuilderImpl sessionIssuer) {
            this.sessionIssuer = sessionIssuer != null ? sessionIssuer.build() : null;
        }

        @Override
        public SessionContext build() {
            return new SessionContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
