/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a classification job, including the current status of the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<List<S3BucketDefinitionForJob>> BUCKET_DEFINITIONS_FIELD = SdkField
            .<List<S3BucketDefinitionForJob>> builder(MarshallingType.LIST)
            .getter(getter(JobSummary::bucketDefinitions))
            .setter(setter(Builder::bucketDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3BucketDefinitionForJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3BucketDefinitionForJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JobSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobSummary::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobSummary::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_DEFINITIONS_FIELD,
            CREATED_AT_FIELD, JOB_ID_FIELD, JOB_STATUS_FIELD, JOB_TYPE_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3BucketDefinitionForJob> bucketDefinitions;

    private final Instant createdAt;

    private final String jobId;

    private final String jobStatus;

    private final String jobType;

    private final String name;

    private JobSummary(BuilderImpl builder) {
        this.bucketDefinitions = builder.bucketDefinitions;
        this.createdAt = builder.createdAt;
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.name = builder.name;
    }

    /**
     * Returns true if the BucketDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBucketDefinitions() {
        return bucketDefinitions != null && !(bucketDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 buckets that the job is configured to analyze.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBucketDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The S3 buckets that the job is configured to analyze.
     */
    public List<S3BucketDefinitionForJob> bucketDefinitions() {
        return bucketDefinitions;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The unique identifier for the job.
     * </p>
     * 
     * @return The unique identifier for the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might also
     * be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected the job's
     * access to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie finished processing all the data specified for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to jobs that occur only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - The job is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
     *         might also be cancelled if ownership of an S3 bucket changed while the job was running, and that change
     *         affected the job's access to the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie finished processing all the data specified for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to jobs that occur only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - The job is in progress.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might also
     * be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected the job's
     * access to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie finished processing all the data specified for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to jobs that occur only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - The job is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
     *         might also be cancelled if ownership of an S3 bucket changed while the job was running, and that change
     *         affected the job's access to the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie finished processing all the data specified for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to jobs that occur only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - The job is in progress.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The schedule for running the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job ran or will run only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job ran or will run only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     *         </p>
     *         </li>
     * @see JobType
     */
    public JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The schedule for running the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job ran or will run only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job ran or will run only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     *         </p>
     *         </li>
     * @see JobType
     */
    public String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The custom name of the job.
     * </p>
     * 
     * @return The custom name of the job.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(bucketDefinitions(), other.bucketDefinitions()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobSummary").add("BucketDefinitions", bucketDefinitions()).add("CreatedAt", createdAt())
                .add("JobId", jobId()).add("JobStatus", jobStatusAsString()).add("JobType", jobTypeAsString())
                .add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketDefinitions":
            return Optional.ofNullable(clazz.cast(bucketDefinitions()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The S3 buckets that the job is configured to analyze.
         * </p>
         * 
         * @param bucketDefinitions
         *        The S3 buckets that the job is configured to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions);

        /**
         * <p>
         * The S3 buckets that the job is configured to analyze.
         * </p>
         * 
         * @param bucketDefinitions
         *        The S3 buckets that the job is configured to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions);

        /**
         * <p>
         * The S3 buckets that the job is configured to analyze.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3BucketDefinitionForJob>.Builder} avoiding
         * the need to create one manually via {@link List<S3BucketDefinitionForJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3BucketDefinitionForJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketDefinitions(List<S3BucketDefinitionForJob>)}.
         * 
         * @param bucketDefinitions
         *        a consumer that will call methods on {@link List<S3BucketDefinitionForJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketDefinitions(List<S3BucketDefinitionForJob>)
         */
        Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The unique identifier for the job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might
         * also be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected
         * the job's access to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie finished processing all the data specified for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to jobs that occur only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - The job is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
         *        might also be cancelled if ownership of an S3 bucket changed while the job was running, and that
         *        change affected the job's access to the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie finished processing all the data specified for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to jobs that occur only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for
         *        your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - The job is in progress.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might
         * also be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected
         * the job's access to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie finished processing all the data specified for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to jobs that occur only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - The job is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
         *        might also be cancelled if ownership of an S3 bucket changed while the job was running, and that
         *        change affected the job's access to the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie finished processing all the data specified for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to jobs that occur only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for
         *        your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - The job is in progress.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The schedule for running the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job ran or will run only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job ran or will run only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The schedule for running the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job ran or will run only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job ran or will run only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The custom name of the job.
         * </p>
         * 
         * @param name
         *        The custom name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private List<S3BucketDefinitionForJob> bucketDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String jobId;

        private String jobStatus;

        private String jobType;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            bucketDefinitions(model.bucketDefinitions);
            createdAt(model.createdAt);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
            jobType(model.jobType);
            name(model.name);
        }

        public final Collection<S3BucketDefinitionForJob.Builder> getBucketDefinitions() {
            return bucketDefinitions != null ? bucketDefinitions.stream().map(S3BucketDefinitionForJob::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copy(bucketDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions) {
            bucketDefinitions(Arrays.asList(bucketDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions) {
            bucketDefinitions(Stream.of(bucketDefinitions).map(c -> S3BucketDefinitionForJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBucketDefinitions(Collection<S3BucketDefinitionForJob.BuilderImpl> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copyFromBuilder(bucketDefinitions);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
