/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageTotalsResponse extends Macie2Response implements
        ToCopyableBuilder<GetUsageTotalsResponse.Builder, GetUsageTotalsResponse> {
    private static final SdkField<List<UsageTotal>> USAGE_TOTALS_FIELD = SdkField
            .<List<UsageTotal>> builder(MarshallingType.LIST)
            .getter(getter(GetUsageTotalsResponse::usageTotals))
            .setter(setter(Builder::usageTotals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTotals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageTotal> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageTotal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_TOTALS_FIELD));

    private final List<UsageTotal> usageTotals;

    private GetUsageTotalsResponse(BuilderImpl builder) {
        super(builder);
        this.usageTotals = builder.usageTotals;
    }

    /**
     * Returns true if the UsageTotals property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsageTotals() {
        return usageTotals != null && !(usageTotals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contains the results of the query. Each object contains the data for a specific usage
     * metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsageTotals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that contains the results of the query. Each object contains the data for a specific
     *         usage metric.
     */
    public List<UsageTotal> usageTotals() {
        return usageTotals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageTotals());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageTotalsResponse)) {
            return false;
        }
        GetUsageTotalsResponse other = (GetUsageTotalsResponse) obj;
        return Objects.equals(usageTotals(), other.usageTotals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUsageTotalsResponse").add("UsageTotals", usageTotals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageTotals":
            return Optional.ofNullable(clazz.cast(usageTotals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageTotalsResponse, T> g) {
        return obj -> g.apply((GetUsageTotalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageTotalsResponse> {
        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for a specific
         * usage metric.
         * </p>
         * 
         * @param usageTotals
         *        An array of objects that contains the results of the query. Each object contains the data for a
         *        specific usage metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTotals(Collection<UsageTotal> usageTotals);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for a specific
         * usage metric.
         * </p>
         * 
         * @param usageTotals
         *        An array of objects that contains the results of the query. Each object contains the data for a
         *        specific usage metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTotals(UsageTotal... usageTotals);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for a specific
         * usage metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageTotal>.Builder} avoiding the need to
         * create one manually via {@link List<UsageTotal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageTotal>.Builder#build()} is called immediately and its
         * result is passed to {@link #usageTotals(List<UsageTotal>)}.
         * 
         * @param usageTotals
         *        a consumer that will call methods on {@link List<UsageTotal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageTotals(List<UsageTotal>)
         */
        Builder usageTotals(Consumer<UsageTotal.Builder>... usageTotals);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<UsageTotal> usageTotals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageTotalsResponse model) {
            super(model);
            usageTotals(model.usageTotals);
        }

        public final Collection<UsageTotal.Builder> getUsageTotals() {
            return usageTotals != null ? usageTotals.stream().map(UsageTotal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usageTotals(Collection<UsageTotal> usageTotals) {
            this.usageTotals = ___listOfUsageTotalCopier.copy(usageTotals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTotals(UsageTotal... usageTotals) {
            usageTotals(Arrays.asList(usageTotals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTotals(Consumer<UsageTotal.Builder>... usageTotals) {
            usageTotals(Stream.of(usageTotals).map(c -> UsageTotal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUsageTotals(Collection<UsageTotal.BuilderImpl> usageTotals) {
            this.usageTotals = ___listOfUsageTotalCopier.copyFromBuilder(usageTotals);
        }

        @Override
        public GetUsageTotalsResponse build() {
            return new GetUsageTotalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
