/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageStatisticsResponse extends Macie2Response implements
        ToCopyableBuilder<GetUsageStatisticsResponse.Builder, GetUsageStatisticsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUsageStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UsageRecord>> RECORDS_FIELD = SdkField
            .<List<UsageRecord>> builder(MarshallingType.LIST)
            .getter(getter(GetUsageStatisticsResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECORDS_FIELD));

    private final String nextToken;

    private final List<UsageRecord> records;

    private GetUsageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.records = builder.records;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contains the results of the query. Each object contains the data for an account that
     * meets the filter criteria specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that contains the results of the query. Each object contains the data for an account
     *         that meets the filter criteria specified in the request.
     */
    public List<UsageRecord> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(records());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsResponse)) {
            return false;
        }
        GetUsageStatisticsResponse other = (GetUsageStatisticsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(records(), other.records());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUsageStatisticsResponse").add("NextToken", nextToken()).add("Records", records()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsResponse, T> g) {
        return obj -> g.apply((GetUsageStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageStatisticsResponse> {
        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * meets the filter criteria specified in the request.
         * </p>
         * 
         * @param records
         *        An array of objects that contains the results of the query. Each object contains the data for an
         *        account that meets the filter criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<UsageRecord> records);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * meets the filter criteria specified in the request.
         * </p>
         * 
         * @param records
         *        An array of objects that contains the results of the query. Each object contains the data for an
         *        account that meets the filter criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(UsageRecord... records);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the data for an account that
         * meets the filter criteria specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageRecord>.Builder} avoiding the need to
         * create one manually via {@link List<UsageRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageRecord>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<UsageRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<UsageRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<UsageRecord>)
         */
        Builder records(Consumer<UsageRecord.Builder>... records);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<UsageRecord> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsResponse model) {
            super(model);
            nextToken(model.nextToken);
            records(model.records);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<UsageRecord.Builder> getRecords() {
            return records != null ? records.stream().map(UsageRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<UsageRecord> records) {
            this.records = ___listOfUsageRecordCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(UsageRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<UsageRecord.Builder>... records) {
            records(Stream.of(records).map(c -> UsageRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<UsageRecord.BuilderImpl> records) {
            this.records = ___listOfUsageRecordCopier.copyFromBuilder(records);
        }

        @Override
        public GetUsageStatisticsResponse build() {
            return new GetUsageStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
