/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketStatisticsResponse extends Macie2Response implements
        ToCopyableBuilder<GetBucketStatisticsResponse.Builder, GetBucketStatisticsResponse> {
    private static final SdkField<Long> BUCKET_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetBucketStatisticsResponse::bucketCount)).setter(setter(Builder::bucketCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCount").build()).build();

    private static final SdkField<BucketCountByEffectivePermission> BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD = SdkField
            .<BucketCountByEffectivePermission> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketStatisticsResponse::bucketCountByEffectivePermission))
            .setter(setter(Builder::bucketCountByEffectivePermission))
            .constructor(BucketCountByEffectivePermission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEffectivePermission")
                    .build()).build();

    private static final SdkField<BucketCountByEncryptionType> BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD = SdkField
            .<BucketCountByEncryptionType> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketStatisticsResponse::bucketCountByEncryptionType))
            .setter(setter(Builder::bucketCountByEncryptionType))
            .constructor(BucketCountByEncryptionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEncryptionType")
                    .build()).build();

    private static final SdkField<BucketCountBySharedAccessType> BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD = SdkField
            .<BucketCountBySharedAccessType> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketStatisticsResponse::bucketCountBySharedAccessType))
            .setter(setter(Builder::bucketCountBySharedAccessType))
            .constructor(BucketCountBySharedAccessType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountBySharedAccessType")
                    .build()).build();

    private static final SdkField<Long> CLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetBucketStatisticsResponse::classifiableObjectCount))
            .setter(setter(Builder::classifiableObjectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableObjectCount").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetBucketStatisticsResponse::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetBucketStatisticsResponse::objectCount)).setter(setter(Builder::objectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCount").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetBucketStatisticsResponse::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytes").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_COMPRESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetBucketStatisticsResponse::sizeInBytesCompressed)).setter(setter(Builder::sizeInBytesCompressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytesCompressed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_COUNT_FIELD,
            BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD, BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD,
            BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD, CLASSIFIABLE_OBJECT_COUNT_FIELD, LAST_UPDATED_FIELD, OBJECT_COUNT_FIELD,
            SIZE_IN_BYTES_FIELD, SIZE_IN_BYTES_COMPRESSED_FIELD));

    private final Long bucketCount;

    private final BucketCountByEffectivePermission bucketCountByEffectivePermission;

    private final BucketCountByEncryptionType bucketCountByEncryptionType;

    private final BucketCountBySharedAccessType bucketCountBySharedAccessType;

    private final Long classifiableObjectCount;

    private final Instant lastUpdated;

    private final Long objectCount;

    private final Long sizeInBytes;

    private final Long sizeInBytesCompressed;

    private GetBucketStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.bucketCount = builder.bucketCount;
        this.bucketCountByEffectivePermission = builder.bucketCountByEffectivePermission;
        this.bucketCountByEncryptionType = builder.bucketCountByEncryptionType;
        this.bucketCountBySharedAccessType = builder.bucketCountBySharedAccessType;
        this.classifiableObjectCount = builder.classifiableObjectCount;
        this.lastUpdated = builder.lastUpdated;
        this.objectCount = builder.objectCount;
        this.sizeInBytes = builder.sizeInBytes;
        this.sizeInBytesCompressed = builder.sizeInBytesCompressed;
    }

    /**
     * <p>
     * The total number of buckets.
     * </p>
     * 
     * @return The total number of buckets.
     */
    public Long bucketCount() {
        return bucketCount;
    }

    /**
     * <p>
     * The total number of buckets that are publicly accessible, based on a combination of permissions settings for each
     * bucket.
     * </p>
     * 
     * @return The total number of buckets that are publicly accessible, based on a combination of permissions settings
     *         for each bucket.
     */
    public BucketCountByEffectivePermission bucketCountByEffectivePermission() {
        return bucketCountByEffectivePermission;
    }

    /**
     * <p>
     * The total number of buckets, grouped by server-side encryption type. This object also reports the total number of
     * buckets that aren't encrypted.
     * </p>
     * 
     * @return The total number of buckets, grouped by server-side encryption type. This object also reports the total
     *         number of buckets that aren't encrypted.
     */
    public BucketCountByEncryptionType bucketCountByEncryptionType() {
        return bucketCountByEncryptionType;
    }

    /**
     * <p>
     * The total number of buckets that are shared with another AWS account or configured to support cross-origin
     * resource sharing (CORS).
     * </p>
     * 
     * @return The total number of buckets that are shared with another AWS account or configured to support
     *         cross-origin resource sharing (CORS).
     */
    public BucketCountBySharedAccessType bucketCountBySharedAccessType() {
        return bucketCountBySharedAccessType;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie can monitor and analyze in all the buckets. These objects use a
     * file format, file extension, or content type that Amazon Macie supports.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie can monitor and analyze in all the buckets. These objects
     *         use a file format, file extension, or content type that Amazon Macie supports.
     */
    public Long classifiableObjectCount() {
        return classifiableObjectCount;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie last analyzed the buckets.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when Amazon Macie last analyzed the buckets.
     */
    public Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The total number of objects in all the buckets.
     * </p>
     * 
     * @return The total number of objects in all the buckets.
     */
    public Long objectCount() {
        return objectCount;
    }

    /**
     * <p>
     * The total storage size, in bytes, of all the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of all the buckets.
     */
    public Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The total compressed storage size, in bytes, of all the buckets.
     * </p>
     * 
     * @return The total compressed storage size, in bytes, of all the buckets.
     */
    public Long sizeInBytesCompressed() {
        return sizeInBytesCompressed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketCount());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountByEffectivePermission());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountByEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountBySharedAccessType());
        hashCode = 31 * hashCode + Objects.hashCode(classifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytesCompressed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketStatisticsResponse)) {
            return false;
        }
        GetBucketStatisticsResponse other = (GetBucketStatisticsResponse) obj;
        return Objects.equals(bucketCount(), other.bucketCount())
                && Objects.equals(bucketCountByEffectivePermission(), other.bucketCountByEffectivePermission())
                && Objects.equals(bucketCountByEncryptionType(), other.bucketCountByEncryptionType())
                && Objects.equals(bucketCountBySharedAccessType(), other.bucketCountBySharedAccessType())
                && Objects.equals(classifiableObjectCount(), other.classifiableObjectCount())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(objectCount(), other.objectCount())
                && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(sizeInBytesCompressed(), other.sizeInBytesCompressed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBucketStatisticsResponse").add("BucketCount", bucketCount())
                .add("BucketCountByEffectivePermission", bucketCountByEffectivePermission())
                .add("BucketCountByEncryptionType", bucketCountByEncryptionType())
                .add("BucketCountBySharedAccessType", bucketCountBySharedAccessType())
                .add("ClassifiableObjectCount", classifiableObjectCount()).add("LastUpdated", lastUpdated())
                .add("ObjectCount", objectCount()).add("SizeInBytes", sizeInBytes())
                .add("SizeInBytesCompressed", sizeInBytesCompressed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketCount":
            return Optional.ofNullable(clazz.cast(bucketCount()));
        case "bucketCountByEffectivePermission":
            return Optional.ofNullable(clazz.cast(bucketCountByEffectivePermission()));
        case "bucketCountByEncryptionType":
            return Optional.ofNullable(clazz.cast(bucketCountByEncryptionType()));
        case "bucketCountBySharedAccessType":
            return Optional.ofNullable(clazz.cast(bucketCountBySharedAccessType()));
        case "classifiableObjectCount":
            return Optional.ofNullable(clazz.cast(classifiableObjectCount()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "objectCount":
            return Optional.ofNullable(clazz.cast(objectCount()));
        case "sizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "sizeInBytesCompressed":
            return Optional.ofNullable(clazz.cast(sizeInBytesCompressed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketStatisticsResponse, T> g) {
        return obj -> g.apply((GetBucketStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketStatisticsResponse> {
        /**
         * <p>
         * The total number of buckets.
         * </p>
         * 
         * @param bucketCount
         *        The total number of buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCount(Long bucketCount);

        /**
         * <p>
         * The total number of buckets that are publicly accessible, based on a combination of permissions settings for
         * each bucket.
         * </p>
         * 
         * @param bucketCountByEffectivePermission
         *        The total number of buckets that are publicly accessible, based on a combination of permissions
         *        settings for each bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission bucketCountByEffectivePermission);

        /**
         * <p>
         * The total number of buckets that are publicly accessible, based on a combination of permissions settings for
         * each bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link BucketCountByEffectivePermission.Builder}
         * avoiding the need to create one manually via {@link BucketCountByEffectivePermission#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountByEffectivePermission.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bucketCountByEffectivePermission(BucketCountByEffectivePermission)}.
         * 
         * @param bucketCountByEffectivePermission
         *        a consumer that will call methods on {@link BucketCountByEffectivePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountByEffectivePermission(BucketCountByEffectivePermission)
         */
        default Builder bucketCountByEffectivePermission(
                Consumer<BucketCountByEffectivePermission.Builder> bucketCountByEffectivePermission) {
            return bucketCountByEffectivePermission(BucketCountByEffectivePermission.builder()
                    .applyMutation(bucketCountByEffectivePermission).build());
        }

        /**
         * <p>
         * The total number of buckets, grouped by server-side encryption type. This object also reports the total
         * number of buckets that aren't encrypted.
         * </p>
         * 
         * @param bucketCountByEncryptionType
         *        The total number of buckets, grouped by server-side encryption type. This object also reports the
         *        total number of buckets that aren't encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountByEncryptionType(BucketCountByEncryptionType bucketCountByEncryptionType);

        /**
         * <p>
         * The total number of buckets, grouped by server-side encryption type. This object also reports the total
         * number of buckets that aren't encrypted.
         * </p>
         * This is a convenience that creates an instance of the {@link BucketCountByEncryptionType.Builder} avoiding
         * the need to create one manually via {@link BucketCountByEncryptionType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountByEncryptionType.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketCountByEncryptionType(BucketCountByEncryptionType)}.
         * 
         * @param bucketCountByEncryptionType
         *        a consumer that will call methods on {@link BucketCountByEncryptionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountByEncryptionType(BucketCountByEncryptionType)
         */
        default Builder bucketCountByEncryptionType(Consumer<BucketCountByEncryptionType.Builder> bucketCountByEncryptionType) {
            return bucketCountByEncryptionType(BucketCountByEncryptionType.builder().applyMutation(bucketCountByEncryptionType)
                    .build());
        }

        /**
         * <p>
         * The total number of buckets that are shared with another AWS account or configured to support cross-origin
         * resource sharing (CORS).
         * </p>
         * 
         * @param bucketCountBySharedAccessType
         *        The total number of buckets that are shared with another AWS account or configured to support
         *        cross-origin resource sharing (CORS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType bucketCountBySharedAccessType);

        /**
         * <p>
         * The total number of buckets that are shared with another AWS account or configured to support cross-origin
         * resource sharing (CORS).
         * </p>
         * This is a convenience that creates an instance of the {@link BucketCountBySharedAccessType.Builder} avoiding
         * the need to create one manually via {@link BucketCountBySharedAccessType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountBySharedAccessType.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketCountBySharedAccessType(BucketCountBySharedAccessType)}
         * .
         * 
         * @param bucketCountBySharedAccessType
         *        a consumer that will call methods on {@link BucketCountBySharedAccessType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountBySharedAccessType(BucketCountBySharedAccessType)
         */
        default Builder bucketCountBySharedAccessType(
                Consumer<BucketCountBySharedAccessType.Builder> bucketCountBySharedAccessType) {
            return bucketCountBySharedAccessType(BucketCountBySharedAccessType.builder()
                    .applyMutation(bucketCountBySharedAccessType).build());
        }

        /**
         * <p>
         * The total number of objects that Amazon Macie can monitor and analyze in all the buckets. These objects use a
         * file format, file extension, or content type that Amazon Macie supports.
         * </p>
         * 
         * @param classifiableObjectCount
         *        The total number of objects that Amazon Macie can monitor and analyze in all the buckets. These
         *        objects use a file format, file extension, or content type that Amazon Macie supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiableObjectCount(Long classifiableObjectCount);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie last analyzed the buckets.
         * </p>
         * 
         * @param lastUpdated
         *        The date and time, in UTC and extended ISO 8601 format, when Amazon Macie last analyzed the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The total number of objects in all the buckets.
         * </p>
         * 
         * @param objectCount
         *        The total number of objects in all the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectCount(Long objectCount);

        /**
         * <p>
         * The total storage size, in bytes, of all the buckets.
         * </p>
         * 
         * @param sizeInBytes
         *        The total storage size, in bytes, of all the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The total compressed storage size, in bytes, of all the buckets.
         * </p>
         * 
         * @param sizeInBytesCompressed
         *        The total compressed storage size, in bytes, of all the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytesCompressed(Long sizeInBytesCompressed);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Long bucketCount;

        private BucketCountByEffectivePermission bucketCountByEffectivePermission;

        private BucketCountByEncryptionType bucketCountByEncryptionType;

        private BucketCountBySharedAccessType bucketCountBySharedAccessType;

        private Long classifiableObjectCount;

        private Instant lastUpdated;

        private Long objectCount;

        private Long sizeInBytes;

        private Long sizeInBytesCompressed;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketStatisticsResponse model) {
            super(model);
            bucketCount(model.bucketCount);
            bucketCountByEffectivePermission(model.bucketCountByEffectivePermission);
            bucketCountByEncryptionType(model.bucketCountByEncryptionType);
            bucketCountBySharedAccessType(model.bucketCountBySharedAccessType);
            classifiableObjectCount(model.classifiableObjectCount);
            lastUpdated(model.lastUpdated);
            objectCount(model.objectCount);
            sizeInBytes(model.sizeInBytes);
            sizeInBytesCompressed(model.sizeInBytesCompressed);
        }

        public final Long getBucketCount() {
            return bucketCount;
        }

        @Override
        public final Builder bucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
            return this;
        }

        public final void setBucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
        }

        public final BucketCountByEffectivePermission.Builder getBucketCountByEffectivePermission() {
            return bucketCountByEffectivePermission != null ? bucketCountByEffectivePermission.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission;
            return this;
        }

        public final void setBucketCountByEffectivePermission(
                BucketCountByEffectivePermission.BuilderImpl bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission != null ? bucketCountByEffectivePermission
                    .build() : null;
        }

        public final BucketCountByEncryptionType.Builder getBucketCountByEncryptionType() {
            return bucketCountByEncryptionType != null ? bucketCountByEncryptionType.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountByEncryptionType(BucketCountByEncryptionType bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType;
            return this;
        }

        public final void setBucketCountByEncryptionType(BucketCountByEncryptionType.BuilderImpl bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType != null ? bucketCountByEncryptionType.build() : null;
        }

        public final BucketCountBySharedAccessType.Builder getBucketCountBySharedAccessType() {
            return bucketCountBySharedAccessType != null ? bucketCountBySharedAccessType.toBuilder() : null;
        }

        @Override
        public final Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType;
            return this;
        }

        public final void setBucketCountBySharedAccessType(BucketCountBySharedAccessType.BuilderImpl bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType != null ? bucketCountBySharedAccessType.build()
                    : null;
        }

        public final Long getClassifiableObjectCount() {
            return classifiableObjectCount;
        }

        @Override
        public final Builder classifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
            return this;
        }

        public final void setClassifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getObjectCount() {
            return objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final Long getSizeInBytesCompressed() {
            return sizeInBytesCompressed;
        }

        @Override
        public final Builder sizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
            return this;
        }

        public final void setSizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
        }

        @Override
        public GetBucketStatisticsResponse build() {
            return new GetBucketStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
