/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The type of finding. Valid values are:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum FindingType {
    SENSITIVE_DATA_S3_OBJECT_MULTIPLE("SensitiveData:S3Object/Multiple"),

    SENSITIVE_DATA_S3_OBJECT_FINANCIAL("SensitiveData:S3Object/Financial"),

    SENSITIVE_DATA_S3_OBJECT_PERSONAL("SensitiveData:S3Object/Personal"),

    SENSITIVE_DATA_S3_OBJECT_CREDENTIALS("SensitiveData:S3Object/Credentials"),

    SENSITIVE_DATA_S3_OBJECT_CUSTOM_IDENTIFIER("SensitiveData:S3Object/CustomIdentifier"),

    POLICY_IAM_USER_S3_BUCKET_PUBLIC("Policy:IAMUser/S3BucketPublic"),

    POLICY_IAM_USER_S3_BUCKET_SHARED_EXTERNALLY("Policy:IAMUser/S3BucketSharedExternally"),

    POLICY_IAM_USER_S3_BUCKET_REPLICATED_EXTERNALLY("Policy:IAMUser/S3BucketReplicatedExternally"),

    POLICY_IAM_USER_S3_BUCKET_ENCRYPTION_DISABLED("Policy:IAMUser/S3BucketEncryptionDisabled"),

    POLICY_IAM_USER_S3_BLOCK_PUBLIC_ACCESS_DISABLED("Policy:IAMUser/S3BlockPublicAccessDisabled"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FindingType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FindingType corresponding to the value
     */
    public static FindingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FindingType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FindingType}s
     */
    public static Set<FindingType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
