/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an entity who performed an action that produced a policy finding for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingActor implements SdkPojo, Serializable, ToCopyableBuilder<FindingActor.Builder, FindingActor> {
    private static final SdkField<DomainDetails> DOMAIN_DETAILS_FIELD = SdkField
            .<DomainDetails> builder(MarshallingType.SDK_POJO).getter(getter(FindingActor::domainDetails))
            .setter(setter(Builder::domainDetails)).constructor(DomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainDetails").build()).build();

    private static final SdkField<IpAddressDetails> IP_ADDRESS_DETAILS_FIELD = SdkField
            .<IpAddressDetails> builder(MarshallingType.SDK_POJO).getter(getter(FindingActor::ipAddressDetails))
            .setter(setter(Builder::ipAddressDetails)).constructor(IpAddressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressDetails").build()).build();

    private static final SdkField<UserIdentity> USER_IDENTITY_FIELD = SdkField.<UserIdentity> builder(MarshallingType.SDK_POJO)
            .getter(getter(FindingActor::userIdentity)).setter(setter(Builder::userIdentity)).constructor(UserIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_DETAILS_FIELD,
            IP_ADDRESS_DETAILS_FIELD, USER_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final DomainDetails domainDetails;

    private final IpAddressDetails ipAddressDetails;

    private final UserIdentity userIdentity;

    private FindingActor(BuilderImpl builder) {
        this.domainDetails = builder.domainDetails;
        this.ipAddressDetails = builder.ipAddressDetails;
        this.userIdentity = builder.userIdentity;
    }

    /**
     * <p>
     * The DNS name of the entity that performed the action on the affected resource.
     * </p>
     * 
     * @return The DNS name of the entity that performed the action on the affected resource.
     */
    public DomainDetails domainDetails() {
        return domainDetails;
    }

    /**
     * <p>
     * The IP address of the device that the entity used to perform the action on the affected resource. This object
     * also provides information such as the owner and geographical location for the IP address.
     * </p>
     * 
     * @return The IP address of the device that the entity used to perform the action on the affected resource. This
     *         object also provides information such as the owner and geographical location for the IP address.
     */
    public IpAddressDetails ipAddressDetails() {
        return ipAddressDetails;
    }

    /**
     * <p>
     * The name and type of entity who performed the action on the affected resource.
     * </p>
     * 
     * @return The name and type of entity who performed the action on the affected resource.
     */
    public UserIdentity userIdentity() {
        return userIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingActor)) {
            return false;
        }
        FindingActor other = (FindingActor) obj;
        return Objects.equals(domainDetails(), other.domainDetails())
                && Objects.equals(ipAddressDetails(), other.ipAddressDetails())
                && Objects.equals(userIdentity(), other.userIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FindingActor").add("DomainDetails", domainDetails()).add("IpAddressDetails", ipAddressDetails())
                .add("UserIdentity", userIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainDetails":
            return Optional.ofNullable(clazz.cast(domainDetails()));
        case "ipAddressDetails":
            return Optional.ofNullable(clazz.cast(ipAddressDetails()));
        case "userIdentity":
            return Optional.ofNullable(clazz.cast(userIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingActor, T> g) {
        return obj -> g.apply((FindingActor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingActor> {
        /**
         * <p>
         * The DNS name of the entity that performed the action on the affected resource.
         * </p>
         * 
         * @param domainDetails
         *        The DNS name of the entity that performed the action on the affected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDetails(DomainDetails domainDetails);

        /**
         * <p>
         * The DNS name of the entity that performed the action on the affected resource.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainDetails.Builder} avoiding the need to
         * create one manually via {@link DomainDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #domainDetails(DomainDetails)}.
         * 
         * @param domainDetails
         *        a consumer that will call methods on {@link DomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDetails(DomainDetails)
         */
        default Builder domainDetails(Consumer<DomainDetails.Builder> domainDetails) {
            return domainDetails(DomainDetails.builder().applyMutation(domainDetails).build());
        }

        /**
         * <p>
         * The IP address of the device that the entity used to perform the action on the affected resource. This object
         * also provides information such as the owner and geographical location for the IP address.
         * </p>
         * 
         * @param ipAddressDetails
         *        The IP address of the device that the entity used to perform the action on the affected resource. This
         *        object also provides information such as the owner and geographical location for the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressDetails(IpAddressDetails ipAddressDetails);

        /**
         * <p>
         * The IP address of the device that the entity used to perform the action on the affected resource. This object
         * also provides information such as the owner and geographical location for the IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link IpAddressDetails.Builder} avoiding the need to
         * create one manually via {@link IpAddressDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpAddressDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ipAddressDetails(IpAddressDetails)}.
         * 
         * @param ipAddressDetails
         *        a consumer that will call methods on {@link IpAddressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAddressDetails(IpAddressDetails)
         */
        default Builder ipAddressDetails(Consumer<IpAddressDetails.Builder> ipAddressDetails) {
            return ipAddressDetails(IpAddressDetails.builder().applyMutation(ipAddressDetails).build());
        }

        /**
         * <p>
         * The name and type of entity who performed the action on the affected resource.
         * </p>
         * 
         * @param userIdentity
         *        The name and type of entity who performed the action on the affected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentity(UserIdentity userIdentity);

        /**
         * <p>
         * The name and type of entity who performed the action on the affected resource.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentity.Builder} avoiding the need to
         * create one manually via {@link UserIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #userIdentity(UserIdentity)}.
         * 
         * @param userIdentity
         *        a consumer that will call methods on {@link UserIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdentity(UserIdentity)
         */
        default Builder userIdentity(Consumer<UserIdentity.Builder> userIdentity) {
            return userIdentity(UserIdentity.builder().applyMutation(userIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainDetails domainDetails;

        private IpAddressDetails ipAddressDetails;

        private UserIdentity userIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingActor model) {
            domainDetails(model.domainDetails);
            ipAddressDetails(model.ipAddressDetails);
            userIdentity(model.userIdentity);
        }

        public final DomainDetails.Builder getDomainDetails() {
            return domainDetails != null ? domainDetails.toBuilder() : null;
        }

        @Override
        public final Builder domainDetails(DomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final void setDomainDetails(DomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        public final IpAddressDetails.Builder getIpAddressDetails() {
            return ipAddressDetails != null ? ipAddressDetails.toBuilder() : null;
        }

        @Override
        public final Builder ipAddressDetails(IpAddressDetails ipAddressDetails) {
            this.ipAddressDetails = ipAddressDetails;
            return this;
        }

        public final void setIpAddressDetails(IpAddressDetails.BuilderImpl ipAddressDetails) {
            this.ipAddressDetails = ipAddressDetails != null ? ipAddressDetails.build() : null;
        }

        public final UserIdentity.Builder getUserIdentity() {
            return userIdentity != null ? userIdentity.toBuilder() : null;
        }

        @Override
        public final Builder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final void setUserIdentity(UserIdentity.BuilderImpl userIdentity) {
            this.userIdentity = userIdentity != null ? userIdentity.build() : null;
        }

        @Override
        public FindingActor build() {
            return new FindingActor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
