/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClassificationJobResponse extends Macie2Response implements
        ToCopyableBuilder<DescribeClassificationJobResponse.Builder, DescribeClassificationJobResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeClassificationJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClassificationJobResponse::customDataIdentifierIds))
            .setter(setter(Builder::customDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeClassificationJobResponse::initialRun)).setter(setter(Builder::initialRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeClassificationJobResponse::lastRunTime))
            .setter(setter(Builder::lastRunTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClassificationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField
            .<S3JobDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeClassificationJobResponse::s3JobDefinition)).setter(setter(Builder::s3JobDefinition))
            .constructor(S3JobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()).build();

    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeClassificationJobResponse::samplingPercentage)).setter(setter(Builder::samplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build())
            .build();

    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField
            .<JobScheduleFrequency> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeClassificationJobResponse::scheduleFrequency)).setter(setter(Builder::scheduleFrequency))
            .constructor(JobScheduleFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()).build();

    private static final SdkField<Statistics> STATISTICS_FIELD = SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeClassificationJobResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(Statistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeClassificationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CREATED_AT_FIELD, CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_ARN_FIELD,
            JOB_ID_FIELD, JOB_STATUS_FIELD, JOB_TYPE_FIELD, LAST_RUN_TIME_FIELD, NAME_FIELD, S3_JOB_DEFINITION_FIELD,
            SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, STATISTICS_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final Instant createdAt;

    private final List<String> customDataIdentifierIds;

    private final String description;

    private final Boolean initialRun;

    private final String jobArn;

    private final String jobId;

    private final String jobStatus;

    private final String jobType;

    private final Instant lastRunTime;

    private final String name;

    private final S3JobDefinition s3JobDefinition;

    private final Integer samplingPercentage;

    private final JobScheduleFrequency scheduleFrequency;

    private final Statistics statistics;

    private final Map<String, String> tags;

    private DescribeClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.lastRunTime = builder.lastRunTime;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The token that was provided to ensure the idempotency of the request to create the job.
     * </p>
     * 
     * @return The token that was provided to ensure the idempotency of the request to create the job.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the CustomDataIdentifierIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCustomDataIdentifierIds() {
        return customDataIdentifierIds != null && !(customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom data identifiers that the job uses to analyze data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomDataIdentifierIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom data identifiers that the job uses to analyze data.
     */
    public List<String> customDataIdentifierIds() {
        return customDataIdentifierIds;
    }

    /**
     * <p>
     * The custom description of the job.
     * </p>
     * 
     * @return The custom description of the job.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the job has run for the first time.
     * </p>
     * 
     * @return Specifies whether the job has run for the first time.
     */
    public Boolean initialRun() {
        return initialRun;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */
    public String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The unique identifier for the job.
     * </p>
     * 
     * @return The unique identifier for the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might also
     * be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected the job's
     * access to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie finished processing all the data specified for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to jobs that occur only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - The job is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
     *         might also be cancelled if ownership of an S3 bucket changed while the job was running, and that change
     *         affected the job's access to the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie finished processing all the data specified for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to jobs that occur only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - The job is in progress.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might also
     * be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected the job's
     * access to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie finished processing all the data specified for the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to jobs that occur only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - The job is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
     *         might also be cancelled if ownership of an S3 bucket changed while the job was running, and that change
     *         affected the job's access to the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie finished processing all the data specified for the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to jobs that occur only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - The job is in progress.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The schedule for running the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job ran or will run only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
     * recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job ran or will run only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates
     *         the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The schedule for running the job. Possible value are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job ran or will run only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
     * recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible value are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job ran or will run only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates
     *         the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job last ran.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job last ran.
     */
    public Instant lastRunTime() {
        return lastRunTime;
    }

    /**
     * <p>
     * The custom name of the job.
     * </p>
     * 
     * @return The custom name of the job.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The S3 buckets that the job is configured to analyze, and the scope of that analysis.
     * </p>
     * 
     * @return The S3 buckets that the job is configured to analyze, and the scope of that analysis.
     */
    public S3JobDefinition s3JobDefinition() {
        return s3JobDefinition;
    }

    /**
     * <p>
     * The sampling depth, as a percentage, that the job applies when it processes objects.
     * </p>
     * 
     * @return The sampling depth, as a percentage, that the job applies when it processes objects.
     */
    public Integer samplingPercentage() {
        return samplingPercentage;
    }

    /**
     * <p>
     * The recurrence pattern for running the job. If the job is configured to run every day, this value is an empty
     * dailySchedule object. If the job is configured to run only once, this value is null.
     * </p>
     * 
     * @return The recurrence pattern for running the job. If the job is configured to run every day, this value is an
     *         empty dailySchedule object. If the job is configured to run only once, this value is null.
     */
    public JobScheduleFrequency scheduleFrequency() {
        return scheduleFrequency;
    }

    /**
     * <p>
     * The number of times that the job has run and processing statistics for the job's most recent run.
     * </p>
     * 
     * @return The number of times that the job has run and processing statistics for the job's most recent run.
     */
    public Statistics statistics() {
        return statistics;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the classification
     * job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of key-value pairs that identifies the tags (keys and values) that are associated with the
     *         classification job.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(customDataIdentifierIds());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassificationJobResponse)) {
            return false;
        }
        DescribeClassificationJobResponse other = (DescribeClassificationJobResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(customDataIdentifierIds(), other.customDataIdentifierIds())
                && Objects.equals(description(), other.description()) && Objects.equals(initialRun(), other.initialRun())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(lastRunTime(), other.lastRunTime()) && Objects.equals(name(), other.name())
                && Objects.equals(s3JobDefinition(), other.s3JobDefinition())
                && Objects.equals(samplingPercentage(), other.samplingPercentage())
                && Objects.equals(scheduleFrequency(), other.scheduleFrequency())
                && Objects.equals(statistics(), other.statistics()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClassificationJobResponse").add("ClientToken", clientToken())
                .add("CreatedAt", createdAt()).add("CustomDataIdentifierIds", customDataIdentifierIds())
                .add("Description", description()).add("InitialRun", initialRun()).add("JobArn", jobArn()).add("JobId", jobId())
                .add("JobStatus", jobStatusAsString()).add("JobType", jobTypeAsString()).add("LastRunTime", lastRunTime())
                .add("Name", name()).add("S3JobDefinition", s3JobDefinition()).add("SamplingPercentage", samplingPercentage())
                .add("ScheduleFrequency", scheduleFrequency()).add("Statistics", statistics()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "customDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(customDataIdentifierIds()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "initialRun":
            return Optional.ofNullable(clazz.cast(initialRun()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "lastRunTime":
            return Optional.ofNullable(clazz.cast(lastRunTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3JobDefinition":
            return Optional.ofNullable(clazz.cast(s3JobDefinition()));
        case "samplingPercentage":
            return Optional.ofNullable(clazz.cast(samplingPercentage()));
        case "scheduleFrequency":
            return Optional.ofNullable(clazz.cast(scheduleFrequency()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClassificationJobResponse, T> g) {
        return obj -> g.apply((DescribeClassificationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClassificationJobResponse> {
        /**
         * <p>
         * The token that was provided to ensure the idempotency of the request to create the job.
         * </p>
         * 
         * @param clientToken
         *        The token that was provided to ensure the idempotency of the request to create the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The custom data identifiers that the job uses to analyze data.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        The custom data identifiers that the job uses to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds);

        /**
         * <p>
         * The custom data identifiers that the job uses to analyze data.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        The custom data identifiers that the job uses to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(String... customDataIdentifierIds);

        /**
         * <p>
         * The custom description of the job.
         * </p>
         * 
         * @param description
         *        The custom description of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the job has run for the first time.
         * </p>
         * 
         * @param initialRun
         *        Specifies whether the job has run for the first time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialRun(Boolean initialRun);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The unique identifier for the job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might
         * also be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected
         * the job's access to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie finished processing all the data specified for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to jobs that occur only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - The job is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
         *        might also be cancelled if ownership of an S3 bucket changed while the job was running, and that
         *        change affected the job's access to the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie finished processing all the data specified for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to jobs that occur only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for
         *        your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - The job is in progress.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job might
         * also be cancelled if ownership of an S3 bucket changed while the job was running, and that change affected
         * the job's access to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie finished processing all the data specified for the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to jobs that occur only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for your
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - The job is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - The job was cancelled by you or a user of the master account for your organization. A job
         *        might also be cancelled if ownership of an S3 bucket changed while the job was running, and that
         *        change affected the job's access to the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie finished processing all the data specified for the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to jobs that occur only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Amazon Macie started the job, but completion of the job would exceed one or more quotas for
         *        your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - The job is in progress.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The schedule for running the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job ran or will run only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
         * recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job ran or will run only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property
         *        indicates the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The schedule for running the job. Possible value are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job ran or will run only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
         * recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible value are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job ran or will run only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property
         *        indicates the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job last ran.
         * </p>
         * 
         * @param lastRunTime
         *        The date and time, in UTC and extended ISO 8601 format, when the job last ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunTime(Instant lastRunTime);

        /**
         * <p>
         * The custom name of the job.
         * </p>
         * 
         * @param name
         *        The custom name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 buckets that the job is configured to analyze, and the scope of that analysis.
         * </p>
         * 
         * @param s3JobDefinition
         *        The S3 buckets that the job is configured to analyze, and the scope of that analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JobDefinition(S3JobDefinition s3JobDefinition);

        /**
         * <p>
         * The S3 buckets that the job is configured to analyze, and the scope of that analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link S3JobDefinition.Builder} avoiding the need to
         * create one manually via {@link S3JobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3JobDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #s3JobDefinition(S3JobDefinition)}.
         * 
         * @param s3JobDefinition
         *        a consumer that will call methods on {@link S3JobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JobDefinition(S3JobDefinition)
         */
        default Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return s3JobDefinition(S3JobDefinition.builder().applyMutation(s3JobDefinition).build());
        }

        /**
         * <p>
         * The sampling depth, as a percentage, that the job applies when it processes objects.
         * </p>
         * 
         * @param samplingPercentage
         *        The sampling depth, as a percentage, that the job applies when it processes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingPercentage(Integer samplingPercentage);

        /**
         * <p>
         * The recurrence pattern for running the job. If the job is configured to run every day, this value is an empty
         * dailySchedule object. If the job is configured to run only once, this value is null.
         * </p>
         * 
         * @param scheduleFrequency
         *        The recurrence pattern for running the job. If the job is configured to run every day, this value is
         *        an empty dailySchedule object. If the job is configured to run only once, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency);

        /**
         * <p>
         * The recurrence pattern for running the job. If the job is configured to run every day, this value is an empty
         * dailySchedule object. If the job is configured to run only once, this value is null.
         * </p>
         * This is a convenience that creates an instance of the {@link JobScheduleFrequency.Builder} avoiding the need
         * to create one manually via {@link JobScheduleFrequency#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobScheduleFrequency.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleFrequency(JobScheduleFrequency)}.
         * 
         * @param scheduleFrequency
         *        a consumer that will call methods on {@link JobScheduleFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleFrequency(JobScheduleFrequency)
         */
        default Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return scheduleFrequency(JobScheduleFrequency.builder().applyMutation(scheduleFrequency).build());
        }

        /**
         * <p>
         * The number of times that the job has run and processing statistics for the job's most recent run.
         * </p>
         * 
         * @param statistics
         *        The number of times that the job has run and processing statistics for the job's most recent run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Statistics statistics);

        /**
         * <p>
         * The number of times that the job has run and processing statistics for the job's most recent run.
         * </p>
         * This is a convenience that creates an instance of the {@link Statistics.Builder} avoiding the need to create
         * one manually via {@link Statistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statistics.Builder#build()} is called immediately and its result
         * is passed to {@link #statistics(Statistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link Statistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(Statistics)
         */
        default Builder statistics(Consumer<Statistics.Builder> statistics) {
            return statistics(Statistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the
         * classification job.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that identifies the tags (keys and values) that are associated with the
         *        classification job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String clientToken;

        private Instant createdAt;

        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean initialRun;

        private String jobArn;

        private String jobId;

        private String jobStatus;

        private String jobType;

        private Instant lastRunTime;

        private String name;

        private S3JobDefinition s3JobDefinition;

        private Integer samplingPercentage;

        private JobScheduleFrequency scheduleFrequency;

        private Statistics statistics;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClassificationJobResponse model) {
            super(model);
            clientToken(model.clientToken);
            createdAt(model.createdAt);
            customDataIdentifierIds(model.customDataIdentifierIds);
            description(model.description);
            initialRun(model.initialRun);
            jobArn(model.jobArn);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
            jobType(model.jobType);
            lastRunTime(model.lastRunTime);
            name(model.name);
            s3JobDefinition(model.s3JobDefinition);
            samplingPercentage(model.samplingPercentage);
            scheduleFrequency(model.scheduleFrequency);
            statistics(model.statistics);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            return customDataIdentifierIds;
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String... customDataIdentifierIds) {
            customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getInitialRun() {
            return initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        public final String getJobArn() {
            return jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final Instant getLastRunTime() {
            return lastRunTime;
        }

        @Override
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return s3JobDefinition != null ? s3JobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        public final Integer getSamplingPercentage() {
            return samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return scheduleFrequency != null ? scheduleFrequency.toBuilder() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        public final Statistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(Statistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeClassificationJobResponse build() {
            return new DescribeClassificationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
