/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the operator to use in an attribute-based condition that filters the results of a query for information
 * about S3 buckets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCriteriaAdditionalProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketCriteriaAdditionalProperties.Builder, BucketCriteriaAdditionalProperties> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BucketCriteriaAdditionalProperties::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> GT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCriteriaAdditionalProperties::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()).build();

    private static final SdkField<Long> GTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCriteriaAdditionalProperties::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()).build();

    private static final SdkField<Long> LT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCriteriaAdditionalProperties::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()).build();

    private static final SdkField<Long> LTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCriteriaAdditionalProperties::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BucketCriteriaAdditionalProperties::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BucketCriteriaAdditionalProperties::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, GT_FIELD, GTE_FIELD,
            LT_FIELD, LTE_FIELD, NEQ_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final Long gt;

    private final Long gte;

    private final Long lt;

    private final Long lte;

    private final List<String> neq;

    private final String prefix;

    private BucketCriteriaAdditionalProperties(BuilderImpl builder) {
        this.eq = builder.eq;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.neq = builder.neq;
        this.prefix = builder.prefix;
    }

    /**
     * Returns true if the Eq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An equal to condition to apply to a specified attribute value for buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An equal to condition to apply to a specified attribute value for buckets.
     */
    public List<String> eq() {
        return eq;
    }

    /**
     * <p>
     * A greater than condition to apply to a specified attribute value for buckets.
     * </p>
     * 
     * @return A greater than condition to apply to a specified attribute value for buckets.
     */
    public Long gt() {
        return gt;
    }

    /**
     * <p>
     * A greater than or equal to condition to apply to a specified attribute value for buckets.
     * </p>
     * 
     * @return A greater than or equal to condition to apply to a specified attribute value for buckets.
     */
    public Long gte() {
        return gte;
    }

    /**
     * <p>
     * A less than condition to apply to a specified attribute value for buckets.
     * </p>
     * 
     * @return A less than condition to apply to a specified attribute value for buckets.
     */
    public Long lt() {
        return lt;
    }

    /**
     * <p>
     * A less than or equal to condition to apply to a specified attribute value for buckets.
     * </p>
     * 
     * @return A less than or equal to condition to apply to a specified attribute value for buckets.
     */
    public Long lte() {
        return lte;
    }

    /**
     * Returns true if the Neq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A not equal to condition to apply to a specified attribute value for buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNeq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A not equal to condition to apply to a specified attribute value for buckets.
     */
    public List<String> neq() {
        return neq;
    }

    /**
     * <p>
     * The prefix of the buckets to include in the results.
     * </p>
     * 
     * @return The prefix of the buckets to include in the results.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eq());
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(neq());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCriteriaAdditionalProperties)) {
            return false;
        }
        BucketCriteriaAdditionalProperties other = (BucketCriteriaAdditionalProperties) obj;
        return Objects.equals(eq(), other.eq()) && Objects.equals(gt(), other.gt()) && Objects.equals(gte(), other.gte())
                && Objects.equals(lt(), other.lt()) && Objects.equals(lte(), other.lte()) && Objects.equals(neq(), other.neq())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BucketCriteriaAdditionalProperties").add("Eq", eq()).add("Gt", gt()).add("Gte", gte())
                .add("Lt", lt()).add("Lte", lte()).add("Neq", neq()).add("Prefix", prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "gt":
            return Optional.ofNullable(clazz.cast(gt()));
        case "gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "lt":
            return Optional.ofNullable(clazz.cast(lt()));
        case "lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "neq":
            return Optional.ofNullable(clazz.cast(neq()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketCriteriaAdditionalProperties, T> g) {
        return obj -> g.apply((BucketCriteriaAdditionalProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCriteriaAdditionalProperties> {
        /**
         * <p>
         * An equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param eq
         *        An equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * An equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param eq
         *        An equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * A greater than condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param gt
         *        A greater than condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(Long gt);

        /**
         * <p>
         * A greater than or equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param gte
         *        A greater than or equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gte(Long gte);

        /**
         * <p>
         * A less than condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param lt
         *        A less than condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(Long lt);

        /**
         * <p>
         * A less than or equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param lte
         *        A less than or equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Long lte);

        /**
         * <p>
         * A not equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param neq
         *        A not equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * A not equal to condition to apply to a specified attribute value for buckets.
         * </p>
         * 
         * @param neq
         *        A not equal to condition to apply to a specified attribute value for buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);

        /**
         * <p>
         * The prefix of the buckets to include in the results.
         * </p>
         * 
         * @param prefix
         *        The prefix of the buckets to include in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCriteriaAdditionalProperties model) {
            eq(model.eq);
            gt(model.gt);
            gte(model.gte);
            lt(model.lt);
            lte(model.lte);
            neq(model.neq);
            prefix(model.prefix);
        }

        public final Collection<String> getEq() {
            return eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
        }

        public final Long getGt() {
            return gt;
        }

        @Override
        public final Builder gt(Long gt) {
            this.gt = gt;
            return this;
        }

        public final void setGt(Long gt) {
            this.gt = gt;
        }

        public final Long getGte() {
            return gte;
        }

        @Override
        public final Builder gte(Long gte) {
            this.gte = gte;
            return this;
        }

        public final void setGte(Long gte) {
            this.gte = gte;
        }

        public final Long getLt() {
            return lt;
        }

        @Override
        public final Builder lt(Long lt) {
            this.lt = lt;
            return this;
        }

        public final void setLt(Long lt) {
            this.lt = lt;
        }

        public final Long getLte() {
            return lte;
        }

        @Override
        public final Builder lte(Long lte) {
            this.lte = lte;
            return this;
        }

        public final void setLte(Long lte) {
            this.lte = lte;
        }

        public final Collection<String> getNeq() {
            return neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public BucketCriteriaAdditionalProperties build() {
            return new BucketCriteriaAdditionalProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
