/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total number of buckets, grouped by server-side encryption type. This object also reports the total number of
 * buckets that aren't encrypted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCountByEncryptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketCountByEncryptionType.Builder, BucketCountByEncryptionType> {
    private static final SdkField<Long> KMS_MANAGED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEncryptionType::kmsManaged)).setter(setter(Builder::kmsManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsManaged").build()).build();

    private static final SdkField<Long> S3_MANAGED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEncryptionType::s3Managed)).setter(setter(Builder::s3Managed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Managed").build()).build();

    private static final SdkField<Long> UNENCRYPTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEncryptionType::unencrypted)).setter(setter(Builder::unencrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unencrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MANAGED_FIELD,
            S3_MANAGED_FIELD, UNENCRYPTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long kmsManaged;

    private final Long s3Managed;

    private final Long unencrypted;

    private BucketCountByEncryptionType(BuilderImpl builder) {
        this.kmsManaged = builder.kmsManaged;
        this.s3Managed = builder.s3Managed;
        this.unencrypted = builder.unencrypted;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long kmsManaged() {
        return kmsManaged;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long s3Managed() {
        return s3Managed;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long unencrypted() {
        return unencrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsManaged());
        hashCode = 31 * hashCode + Objects.hashCode(s3Managed());
        hashCode = 31 * hashCode + Objects.hashCode(unencrypted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCountByEncryptionType)) {
            return false;
        }
        BucketCountByEncryptionType other = (BucketCountByEncryptionType) obj;
        return Objects.equals(kmsManaged(), other.kmsManaged()) && Objects.equals(s3Managed(), other.s3Managed())
                && Objects.equals(unencrypted(), other.unencrypted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BucketCountByEncryptionType").add("KmsManaged", kmsManaged()).add("S3Managed", s3Managed())
                .add("Unencrypted", unencrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsManaged":
            return Optional.ofNullable(clazz.cast(kmsManaged()));
        case "s3Managed":
            return Optional.ofNullable(clazz.cast(s3Managed()));
        case "unencrypted":
            return Optional.ofNullable(clazz.cast(unencrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketCountByEncryptionType, T> g) {
        return obj -> g.apply((BucketCountByEncryptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCountByEncryptionType> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param kmsManaged
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsManaged(Long kmsManaged);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param s3Managed
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Managed(Long s3Managed);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param unencrypted
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unencrypted(Long unencrypted);
    }

    static final class BuilderImpl implements Builder {
        private Long kmsManaged;

        private Long s3Managed;

        private Long unencrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCountByEncryptionType model) {
            kmsManaged(model.kmsManaged);
            s3Managed(model.s3Managed);
            unencrypted(model.unencrypted);
        }

        public final Long getKmsManaged() {
            return kmsManaged;
        }

        @Override
        public final Builder kmsManaged(Long kmsManaged) {
            this.kmsManaged = kmsManaged;
            return this;
        }

        public final void setKmsManaged(Long kmsManaged) {
            this.kmsManaged = kmsManaged;
        }

        public final Long getS3Managed() {
            return s3Managed;
        }

        @Override
        public final Builder s3Managed(Long s3Managed) {
            this.s3Managed = s3Managed;
            return this;
        }

        public final void setS3Managed(Long s3Managed) {
            this.s3Managed = s3Managed;
        }

        public final Long getUnencrypted() {
            return unencrypted;
        }

        @Override
        public final Builder unencrypted(Long unencrypted) {
            this.unencrypted = unencrypted;
            return this;
        }

        public final void setUnencrypted(Long unencrypted) {
            this.unencrypted = unencrypted;
        }

        @Override
        public BucketCountByEncryptionType build() {
            return new BucketCountByEncryptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
