/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total number of buckets that are publicly accessible, based on a combination of permissions settings for each
 * bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCountByEffectivePermission implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketCountByEffectivePermission.Builder, BucketCountByEffectivePermission> {
    private static final SdkField<Long> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEffectivePermission::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<Long> PUBLICLY_READABLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEffectivePermission::publiclyReadable)).setter(setter(Builder::publiclyReadable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyReadable").build()).build();

    private static final SdkField<Long> PUBLICLY_WRITABLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(BucketCountByEffectivePermission::publiclyWritable)).setter(setter(Builder::publiclyWritable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyWritable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLICLY_ACCESSIBLE_FIELD,
            PUBLICLY_READABLE_FIELD, PUBLICLY_WRITABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long publiclyAccessible;

    private final Long publiclyReadable;

    private final Long publiclyWritable;

    private BucketCountByEffectivePermission(BuilderImpl builder) {
        this.publiclyAccessible = builder.publiclyAccessible;
        this.publiclyReadable = builder.publiclyReadable;
        this.publiclyWritable = builder.publiclyWritable;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long publiclyReadable() {
        return publiclyReadable;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Long publiclyWritable() {
        return publiclyWritable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyReadable());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyWritable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCountByEffectivePermission)) {
            return false;
        }
        BucketCountByEffectivePermission other = (BucketCountByEffectivePermission) obj;
        return Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(publiclyReadable(), other.publiclyReadable())
                && Objects.equals(publiclyWritable(), other.publiclyWritable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BucketCountByEffectivePermission").add("PubliclyAccessible", publiclyAccessible())
                .add("PubliclyReadable", publiclyReadable()).add("PubliclyWritable", publiclyWritable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "publiclyReadable":
            return Optional.ofNullable(clazz.cast(publiclyReadable()));
        case "publiclyWritable":
            return Optional.ofNullable(clazz.cast(publiclyWritable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketCountByEffectivePermission, T> g) {
        return obj -> g.apply((BucketCountByEffectivePermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCountByEffectivePermission> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param publiclyAccessible
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Long publiclyAccessible);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param publiclyReadable
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyReadable(Long publiclyReadable);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param publiclyWritable
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyWritable(Long publiclyWritable);
    }

    static final class BuilderImpl implements Builder {
        private Long publiclyAccessible;

        private Long publiclyReadable;

        private Long publiclyWritable;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCountByEffectivePermission model) {
            publiclyAccessible(model.publiclyAccessible);
            publiclyReadable(model.publiclyReadable);
            publiclyWritable(model.publiclyWritable);
        }

        public final Long getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Long publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Long publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Long getPubliclyReadable() {
            return publiclyReadable;
        }

        @Override
        public final Builder publiclyReadable(Long publiclyReadable) {
            this.publiclyReadable = publiclyReadable;
            return this;
        }

        public final void setPubliclyReadable(Long publiclyReadable) {
            this.publiclyReadable = publiclyReadable;
        }

        public final Long getPubliclyWritable() {
            return publiclyWritable;
        }

        @Override
        public final Builder publiclyWritable(Long publiclyWritable) {
            this.publiclyWritable = publiclyWritable;
            return this;
        }

        public final void setPubliclyWritable(Long publiclyWritable) {
            this.publiclyWritable = publiclyWritable;
        }

        @Override
        public BucketCountByEffectivePermission build() {
            return new BucketCountByEffectivePermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
