/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the block public access settings for an S3 bucket. These settings can apply to a bucket at
 * the account level or bucket level. For detailed information about each setting, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 block
 * public access</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockPublicAccess implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockPublicAccess.Builder, BlockPublicAccess> {
    private static final SdkField<Boolean> BLOCK_PUBLIC_ACLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BlockPublicAccess::blockPublicAcls)).setter(setter(Builder::blockPublicAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAcls").build()).build();

    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BlockPublicAccess::blockPublicPolicy)).setter(setter(Builder::blockPublicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicPolicy").build()).build();

    private static final SdkField<Boolean> IGNORE_PUBLIC_ACLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BlockPublicAccess::ignorePublicAcls)).setter(setter(Builder::ignorePublicAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignorePublicAcls").build()).build();

    private static final SdkField<Boolean> RESTRICT_PUBLIC_BUCKETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BlockPublicAccess::restrictPublicBuckets)).setter(setter(Builder::restrictPublicBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictPublicBuckets").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_ACLS_FIELD,
            BLOCK_PUBLIC_POLICY_FIELD, IGNORE_PUBLIC_ACLS_FIELD, RESTRICT_PUBLIC_BUCKETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean blockPublicAcls;

    private final Boolean blockPublicPolicy;

    private final Boolean ignorePublicAcls;

    private final Boolean restrictPublicBuckets;

    private BlockPublicAccess(BuilderImpl builder) {
        this.blockPublicAcls = builder.blockPublicAcls;
        this.blockPublicPolicy = builder.blockPublicPolicy;
        this.ignorePublicAcls = builder.ignorePublicAcls;
        this.restrictPublicBuckets = builder.restrictPublicBuckets;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the
     *         bucket.
     */
    public Boolean blockPublicAcls() {
        return blockPublicAcls;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 blocks public bucket policies for the bucket.
     */
    public Boolean blockPublicPolicy() {
        return blockPublicPolicy;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
     */
    public Boolean ignorePublicAcls() {
        return ignorePublicAcls;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 restricts public bucket policies for the bucket.
     */
    public Boolean restrictPublicBuckets() {
        return restrictPublicBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(ignorePublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(restrictPublicBuckets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccess)) {
            return false;
        }
        BlockPublicAccess other = (BlockPublicAccess) obj;
        return Objects.equals(blockPublicAcls(), other.blockPublicAcls())
                && Objects.equals(blockPublicPolicy(), other.blockPublicPolicy())
                && Objects.equals(ignorePublicAcls(), other.ignorePublicAcls())
                && Objects.equals(restrictPublicBuckets(), other.restrictPublicBuckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BlockPublicAccess").add("BlockPublicAcls", blockPublicAcls())
                .add("BlockPublicPolicy", blockPublicPolicy()).add("IgnorePublicAcls", ignorePublicAcls())
                .add("RestrictPublicBuckets", restrictPublicBuckets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockPublicAcls":
            return Optional.ofNullable(clazz.cast(blockPublicAcls()));
        case "blockPublicPolicy":
            return Optional.ofNullable(clazz.cast(blockPublicPolicy()));
        case "ignorePublicAcls":
            return Optional.ofNullable(clazz.cast(ignorePublicAcls()));
        case "restrictPublicBuckets":
            return Optional.ofNullable(clazz.cast(restrictPublicBuckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockPublicAccess, T> g) {
        return obj -> g.apply((BlockPublicAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockPublicAccess> {
        /**
         * <p>
         * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the
         * bucket.
         * </p>
         * 
         * @param blockPublicAcls
         *        Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in
         *        the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAcls(Boolean blockPublicAcls);

        /**
         * <p>
         * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
         * </p>
         * 
         * @param blockPublicPolicy
         *        Specifies whether Amazon S3 blocks public bucket policies for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicPolicy(Boolean blockPublicPolicy);

        /**
         * <p>
         * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
         * </p>
         * 
         * @param ignorePublicAcls
         *        Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignorePublicAcls(Boolean ignorePublicAcls);

        /**
         * <p>
         * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
         * </p>
         * 
         * @param restrictPublicBuckets
         *        Specifies whether Amazon S3 restricts public bucket policies for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictPublicBuckets(Boolean restrictPublicBuckets);
    }

    static final class BuilderImpl implements Builder {
        private Boolean blockPublicAcls;

        private Boolean blockPublicPolicy;

        private Boolean ignorePublicAcls;

        private Boolean restrictPublicBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockPublicAccess model) {
            blockPublicAcls(model.blockPublicAcls);
            blockPublicPolicy(model.blockPublicPolicy);
            ignorePublicAcls(model.ignorePublicAcls);
            restrictPublicBuckets(model.restrictPublicBuckets);
        }

        public final Boolean getBlockPublicAcls() {
            return blockPublicAcls;
        }

        @Override
        public final Builder blockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
            return this;
        }

        public final void setBlockPublicAcls(Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
        }

        public final Boolean getBlockPublicPolicy() {
            return blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        public final Boolean getIgnorePublicAcls() {
            return ignorePublicAcls;
        }

        @Override
        public final Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        public final void setIgnorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
        }

        public final Boolean getRestrictPublicBuckets() {
            return restrictPublicBuckets;
        }

        @Override
        public final Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        public final void setRestrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
        }

        @Override
        public BlockPublicAccess build() {
            return new BlockPublicAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
