/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptInvitationRequest extends Macie2Request implements
        ToCopyableBuilder<AcceptInvitationRequest.Builder, AcceptInvitationRequest> {
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptInvitationRequest::invitationId)).setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()).build();

    private static final SdkField<String> MASTER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptInvitationRequest::masterAccount)).setter(setter(Builder::masterAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterAccount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATION_ID_FIELD,
            MASTER_ACCOUNT_FIELD));

    private final String invitationId;

    private final String masterAccount;

    private AcceptInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.invitationId = builder.invitationId;
        this.masterAccount = builder.masterAccount;
    }

    /**
     * <p>
     * The unique identifier for the invitation to accept.
     * </p>
     * 
     * @return The unique identifier for the invitation to accept.
     */
    public String invitationId() {
        return invitationId;
    }

    /**
     * <p>
     * The AWS account ID for the account that sent the invitation.
     * </p>
     * 
     * @return The AWS account ID for the account that sent the invitation.
     */
    public String masterAccount() {
        return masterAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(masterAccount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInvitationRequest)) {
            return false;
        }
        AcceptInvitationRequest other = (AcceptInvitationRequest) obj;
        return Objects.equals(invitationId(), other.invitationId()) && Objects.equals(masterAccount(), other.masterAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AcceptInvitationRequest").add("InvitationId", invitationId())
                .add("MasterAccount", masterAccount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        case "masterAccount":
            return Optional.ofNullable(clazz.cast(masterAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptInvitationRequest, T> g) {
        return obj -> g.apply((AcceptInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, AcceptInvitationRequest> {
        /**
         * <p>
         * The unique identifier for the invitation to accept.
         * </p>
         * 
         * @param invitationId
         *        The unique identifier for the invitation to accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        /**
         * <p>
         * The AWS account ID for the account that sent the invitation.
         * </p>
         * 
         * @param masterAccount
         *        The AWS account ID for the account that sent the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterAccount(String masterAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String invitationId;

        private String masterAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInvitationRequest model) {
            super(model);
            invitationId(model.invitationId);
            masterAccount(model.masterAccount);
        }

        public final String getInvitationId() {
            return invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getMasterAccount() {
            return masterAccount;
        }

        @Override
        public final Builder masterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
            return this;
        }

        public final void setMasterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInvitationRequest build() {
            return new AcceptInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
