/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.macie2.model.AccessDeniedException;
import software.amazon.awssdk.services.macie2.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.macie2.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ConflictException;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.CreateMemberRequest;
import software.amazon.awssdk.services.macie2.model.CreateMemberResponse;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteMemberRequest;
import software.amazon.awssdk.services.macie2.model.DeleteMemberResponse;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.DisableMacieRequest;
import software.amazon.awssdk.services.macie2.model.DisableMacieResponse;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.macie2.model.EnableMacieRequest;
import software.amazon.awssdk.services.macie2.model.EnableMacieResponse;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsResponse;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetMemberRequest;
import software.amazon.awssdk.services.macie2.model.GetMemberResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse;
import software.amazon.awssdk.services.macie2.model.InternalServerException;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsResponse;
import software.amazon.awssdk.services.macie2.model.ListInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.ListInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.ListMembersRequest;
import software.amazon.awssdk.services.macie2.model.ListMembersResponse;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.macie2.model.Macie2Exception;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.macie2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.macie2.model.TagResourceRequest;
import software.amazon.awssdk.services.macie2.model.TagResourceResponse;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.ThrottlingException;
import software.amazon.awssdk.services.macie2.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.macie2.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.macie2.model.UntagResourceRequest;
import software.amazon.awssdk.services.macie2.model.UntagResourceResponse;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.ValidationException;
import software.amazon.awssdk.services.macie2.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ArchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.BatchGetCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeBucketsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetBucketStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageTotalsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsFiltersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListOrganizationAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.PutClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TestCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UnarchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMemberSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Macie2AsyncClient}.
 *
 * @see Macie2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMacie2AsyncClient implements Macie2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMacie2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMacie2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.AcceptInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInvitationRequest, AcceptInvitationResponse>()
                            .withOperationName("AcceptInvitation")
                            .withMarshaller(new AcceptInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptInvitationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Archives one or more findings.
     * </p>
     *
     * @param archiveFindingsRequest
     * @return A Java Future containing the result of the ArchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ArchiveFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ArchiveFindingsResponse> archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ArchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ArchiveFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ArchiveFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ArchiveFindingsRequest, ArchiveFindingsResponse>()
                            .withOperationName("ArchiveFindings")
                            .withMarshaller(new ArchiveFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(archiveFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about one or more custom data identifiers.
     * </p>
     *
     * @param batchGetCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the BatchGetCustomDataIdentifiers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.BatchGetCustomDataIdentifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCustomDataIdentifiersResponse> batchGetCustomDataIdentifiers(
            BatchGetCustomDataIdentifiersRequest batchGetCustomDataIdentifiersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCustomDataIdentifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetCustomDataIdentifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetCustomDataIdentifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCustomDataIdentifiersRequest, BatchGetCustomDataIdentifiersResponse>()
                            .withOperationName("BatchGetCustomDataIdentifiers")
                            .withMarshaller(new BatchGetCustomDataIdentifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchGetCustomDataIdentifiersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the settings for a classification job.
     * </p>
     *
     * @param createClassificationJobRequest
     * @return A Java Future containing the result of the CreateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateClassificationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClassificationJobResponse> createClassificationJob(
            CreateClassificationJobRequest createClassificationJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClassificationJobRequest, CreateClassificationJobResponse>()
                            .withOperationName("CreateClassificationJob")
                            .withMarshaller(new CreateClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createClassificationJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param createCustomDataIdentifierRequest
     * @return A Java Future containing the result of the CreateCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateCustomDataIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomDataIdentifierResponse> createCustomDataIdentifier(
            CreateCustomDataIdentifierRequest createCustomDataIdentifierRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDataIdentifierRequest, CreateCustomDataIdentifierResponse>()
                            .withOperationName("CreateCustomDataIdentifier")
                            .withMarshaller(new CreateCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCustomDataIdentifierRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a findings filter.
     * </p>
     *
     * @param createFindingsFilterRequest
     * @return A Java Future containing the result of the CreateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateFindingsFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFindingsFilterResponse> createFindingsFilter(
            CreateFindingsFilterRequest createFindingsFilterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFindingsFilterRequest, CreateFindingsFilterResponse>()
                            .withOperationName("CreateFindingsFilter")
                            .withMarshaller(new CreateFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFindingsFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends an Amazon Macie membership invitation to one or more accounts.
     * </p>
     *
     * @param createInvitationsRequest
     * @return A Java Future containing the result of the CreateInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInvitationsResponse> createInvitations(CreateInvitationsRequest createInvitationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInvitationsRequest, CreateInvitationsResponse>()
                            .withOperationName("CreateInvitations")
                            .withMarshaller(new CreateInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInvitationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an account with an Amazon Macie master account.
     * </p>
     *
     * @param createMemberRequest
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateMember
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMemberResponse> createMember(CreateMemberRequest createMemberRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMemberRequest, CreateMemberResponse>()
                            .withOperationName("CreateMember").withMarshaller(new CreateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createMemberRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates sample findings.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateSampleFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            CreateSampleFindingsRequest createSampleFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSampleFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSampleFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSampleFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSampleFindingsRequest, CreateSampleFindingsResponse>()
                            .withOperationName("CreateSampleFindings")
                            .withMarshaller(new CreateSampleFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSampleFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeclineInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeclineInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeclineInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeclineInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeclineInvitationsRequest, DeclineInvitationsResponse>()
                            .withOperationName("DeclineInvitations")
                            .withMarshaller(new DeclineInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(declineInvitationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom data identifier.
     * </p>
     *
     * @param deleteCustomDataIdentifierRequest
     * @return A Java Future containing the result of the DeleteCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteCustomDataIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomDataIdentifierResponse> deleteCustomDataIdentifier(
            DeleteCustomDataIdentifierRequest deleteCustomDataIdentifierRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDataIdentifierRequest, DeleteCustomDataIdentifierResponse>()
                            .withOperationName("DeleteCustomDataIdentifier")
                            .withMarshaller(new DeleteCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteCustomDataIdentifierRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a findings filter.
     * </p>
     *
     * @param deleteFindingsFilterRequest
     * @return A Java Future containing the result of the DeleteFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteFindingsFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFindingsFilterResponse> deleteFindingsFilter(
            DeleteFindingsFilterRequest deleteFindingsFilterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFindingsFilterRequest, DeleteFindingsFilterResponse>()
                            .withOperationName("DeleteFindingsFilter")
                            .withMarshaller(new DeleteFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFindingsFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInvitationsRequest, DeleteInvitationsResponse>()
                            .withOperationName("DeleteInvitations")
                            .withMarshaller(new DeleteInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInvitationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the association between an Amazon Macie master account and an account.
     * </p>
     *
     * @param deleteMemberRequest
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteMember
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMemberResponse> deleteMember(DeleteMemberRequest deleteMemberRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMemberRequest, DeleteMemberResponse>()
                            .withOperationName("DeleteMember").withMarshaller(new DeleteMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteMemberRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes.
     * </p>
     *
     * @param describeBucketsRequest
     * @return A Java Future containing the result of the DescribeBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBucketsResponse> describeBuckets(DescribeBucketsRequest describeBucketsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBucketsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBucketsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBucketsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBucketsRequest, DescribeBucketsResponse>()
                            .withOperationName("DescribeBuckets")
                            .withMarshaller(new DescribeBucketsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeBucketsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings for a classification job.
     * </p>
     *
     * @param describeClassificationJobRequest
     * @return A Java Future containing the result of the DescribeClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeClassificationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClassificationJobResponse> describeClassificationJob(
            DescribeClassificationJobRequest describeClassificationJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClassificationJobRequest, DescribeClassificationJobResponse>()
                            .withOperationName("DescribeClassificationJob")
                            .withMarshaller(new DescribeClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClassificationJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie configuration settings for an AWS organization.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse>()
                            .withOperationName("DescribeOrganizationConfiguration")
                            .withMarshaller(new DescribeOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrganizationConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables an Amazon Macie account and deletes Macie resources for the account.
     * </p>
     *
     * @param disableMacieRequest
     * @return A Java Future containing the result of the DisableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableMacie
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableMacieResponse> disableMacie(DisableMacieRequest disableMacieRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableMacieResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableMacieResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableMacieResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableMacieRequest, DisableMacieResponse>()
                            .withOperationName("DisableMacie").withMarshaller(new DisableMacieRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableMacieRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables an account as a delegated administrator of Amazon Macie for an AWS organization.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableOrganizationAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse>()
                            .withOperationName("DisableOrganizationAdminAccount")
                            .withMarshaller(new DisableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableOrganizationAdminAccountRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member account from its Amazon Macie master account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFromMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFromMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFromMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse>()
                            .withOperationName("DisassociateFromMasterAccount")
                            .withMarshaller(new DisassociateFromMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateFromMasterAccountRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Macie master account from a member account.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateMember
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberResponse> disassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberRequest, DisassociateMemberResponse>()
                            .withOperationName("DisassociateMember")
                            .withMarshaller(new DisassociateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateMemberRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     * </p>
     *
     * @param enableMacieRequest
     * @return A Java Future containing the result of the EnableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableMacie
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableMacieResponse> enableMacie(EnableMacieRequest enableMacieRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableMacieResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableMacieResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableMacieResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableMacieRequest, EnableMacieResponse>()
                            .withOperationName("EnableMacie").withMarshaller(new EnableMacieRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableMacieRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables an account as a delegated administrator of Amazon Macie for an AWS organization.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableOrganizationAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse>()
                            .withOperationName("EnableOrganizationAdminAccount")
                            .withMarshaller(new EnableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableOrganizationAdminAccountRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.
     * </p>
     *
     * @param getBucketStatisticsRequest
     * @return A Java Future containing the result of the GetBucketStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetBucketStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketStatisticsResponse> getBucketStatistics(
            GetBucketStatisticsRequest getBucketStatisticsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBucketStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBucketStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBucketStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketStatisticsRequest, GetBucketStatisticsResponse>()
                            .withOperationName("GetBucketStatistics")
                            .withMarshaller(new GetBucketStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBucketStatisticsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration settings for exporting data classification results.
     * </p>
     *
     * @param getClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the GetClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetClassificationExportConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetClassificationExportConfigurationResponse> getClassificationExportConfiguration(
            GetClassificationExportConfigurationRequest getClassificationExportConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClassificationExportConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetClassificationExportConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClassificationExportConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClassificationExportConfigurationRequest, GetClassificationExportConfigurationResponse>()
                            .withOperationName("GetClassificationExportConfiguration")
                            .withMarshaller(new GetClassificationExportConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getClassificationExportConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param getCustomDataIdentifierRequest
     * @return A Java Future containing the result of the GetCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetCustomDataIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCustomDataIdentifierResponse> getCustomDataIdentifier(
            GetCustomDataIdentifierRequest getCustomDataIdentifierRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCustomDataIdentifierRequest, GetCustomDataIdentifierResponse>()
                            .withOperationName("GetCustomDataIdentifier")
                            .withMarshaller(new GetCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCustomDataIdentifierRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about findings.
     * </p>
     *
     * @param getFindingStatisticsRequest
     * @return A Java Future containing the result of the GetFindingStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingStatisticsResponse> getFindingStatistics(
            GetFindingStatisticsRequest getFindingStatisticsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingStatisticsRequest, GetFindingStatisticsResponse>()
                            .withOperationName("GetFindingStatistics")
                            .withMarshaller(new GetFindingStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFindingStatisticsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about one or more findings.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsRequest, GetFindingsResponse>()
                            .withOperationName("GetFindings").withMarshaller(new GetFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the criteria and other settings for a findings filter.
     * </p>
     *
     * @param getFindingsFilterRequest
     * @return A Java Future containing the result of the GetFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsFilterResponse> getFindingsFilter(GetFindingsFilterRequest getFindingsFilterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsFilterRequest, GetFindingsFilterResponse>()
                            .withOperationName("GetFindingsFilter")
                            .withMarshaller(new GetFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFindingsFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetInvitationsCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInvitationsCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInvitationsCountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInvitationsCountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInvitationsCountRequest, GetInvitationsCountResponse>()
                            .withOperationName("GetInvitationsCount")
                            .withMarshaller(new GetInvitationsCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInvitationsCountRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the current status and configuration settings for an Amazon Macie account.
     * </p>
     *
     * @param getMacieSessionRequest
     * @return A Java Future containing the result of the GetMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMacieSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMacieSessionResponse> getMacieSession(GetMacieSessionRequest getMacieSessionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMacieSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMacieSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMacieSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMacieSessionRequest, GetMacieSessionResponse>()
                            .withOperationName("GetMacieSession")
                            .withMarshaller(new GetMacieSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMacieSessionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie master account for an account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMasterAccountRequest, GetMasterAccountResponse>()
                            .withOperationName("GetMasterAccount")
                            .withMarshaller(new GetMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMasterAccountRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a member account that's associated with an Amazon Macie master account.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMember
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMemberRequest, GetMemberResponse>().withOperationName("GetMember")
                            .withMarshaller(new GetMemberRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMemberRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsageStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageStatisticsRequest, GetUsageStatisticsResponse>()
                            .withOperationName("GetUsageStatistics")
                            .withMarshaller(new GetUsageStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getUsageStatisticsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) aggregated usage data for an account.
     * </p>
     *
     * @param getUsageTotalsRequest
     * @return A Java Future containing the result of the GetUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageTotals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageTotalsResponse> getUsageTotals(GetUsageTotalsRequest getUsageTotalsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageTotalsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsageTotalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageTotalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageTotalsRequest, GetUsageTotalsResponse>()
                            .withOperationName("GetUsageTotals")
                            .withMarshaller(new GetUsageTotalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getUsageTotalsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings for one or more classification jobs.
     * </p>
     *
     * @param listClassificationJobsRequest
     * @return A Java Future containing the result of the ListClassificationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListClassificationJobsResponse> listClassificationJobs(
            ListClassificationJobsRequest listClassificationJobsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListClassificationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListClassificationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListClassificationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListClassificationJobsRequest, ListClassificationJobsResponse>()
                            .withOperationName("ListClassificationJobs")
                            .withMarshaller(new ListClassificationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listClassificationJobsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the ListCustomDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomDataIdentifiersResponse> listCustomDataIdentifiers(
            ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomDataIdentifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomDataIdentifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomDataIdentifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomDataIdentifiersRequest, ListCustomDataIdentifiersResponse>()
                            .withOperationName("ListCustomDataIdentifiers")
                            .withMarshaller(new ListCustomDataIdentifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCustomDataIdentifiersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsRequest, ListFindingsResponse>()
                            .withOperationName("ListFindings").withMarshaller(new ListFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     *
     * @param listFindingsFiltersRequest
     * @return A Java Future containing the result of the ListFindingsFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsFiltersResponse> listFindingsFilters(
            ListFindingsFiltersRequest listFindingsFiltersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsFiltersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFindingsFiltersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsFiltersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsFiltersRequest, ListFindingsFiltersResponse>()
                            .withOperationName("ListFindingsFilters")
                            .withMarshaller(new ListFindingsFiltersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listFindingsFiltersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInvitationsRequest, ListInvitationsResponse>()
                            .withOperationName("ListInvitations")
                            .withMarshaller(new ListInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listInvitationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie master account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                            .withOperationName("ListMembers").withMarshaller(new ListMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listMembersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the account that's designated as the delegated administrator of Amazon Macie for an
     * AWS organization.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationAdminAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationAdminAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationAdminAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse>()
                            .withOperationName("ListOrganizationAdminAccounts")
                            .withMarshaller(new ListOrganizationAdminAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listOrganizationAdminAccountsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier,
     * findings filter, or member account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTagsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates the configuration settings for exporting data classification results.
     * </p>
     *
     * @param putClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the PutClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutClassificationExportConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutClassificationExportConfigurationResponse> putClassificationExportConfiguration(
            PutClassificationExportConfigurationRequest putClassificationExportConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutClassificationExportConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutClassificationExportConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutClassificationExportConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutClassificationExportConfigurationRequest, PutClassificationExportConfigurationResponse>()
                            .withOperationName("PutClassificationExportConfiguration")
                            .withMarshaller(new PutClassificationExportConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putClassificationExportConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data
     * identifier, findings filter, or member account.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests a custom data identifier.
     * </p>
     *
     * @param testCustomDataIdentifierRequest
     * @return A Java Future containing the result of the TestCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TestCustomDataIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestCustomDataIdentifierResponse> testCustomDataIdentifier(
            TestCustomDataIdentifierRequest testCustomDataIdentifierRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestCustomDataIdentifierRequest, TestCustomDataIdentifierResponse>()
                            .withOperationName("TestCustomDataIdentifier")
                            .withMarshaller(new TestCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(testCustomDataIdentifierRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reactivates (unarchives) one or more findings.
     * </p>
     *
     * @param unarchiveFindingsRequest
     * @return A Java Future containing the result of the UnarchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UnarchiveFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UnarchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnarchiveFindingsResponse> unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnarchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UnarchiveFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnarchiveFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnarchiveFindingsRequest, UnarchiveFindingsResponse>()
                            .withOperationName("UnarchiveFindings")
                            .withMarshaller(new UnarchiveFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(unarchiveFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or
     * member account.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a classification job.
     * </p>
     *
     * @param updateClassificationJobRequest
     * @return A Java Future containing the result of the UpdateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateClassificationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateClassificationJobResponse> updateClassificationJob(
            UpdateClassificationJobRequest updateClassificationJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClassificationJobRequest, UpdateClassificationJobResponse>()
                            .withOperationName("UpdateClassificationJob")
                            .withMarshaller(new UpdateClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateClassificationJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the criteria and other settings for a findings filter.
     * </p>
     *
     * @param updateFindingsFilterRequest
     * @return A Java Future containing the result of the UpdateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateFindingsFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFindingsFilterResponse> updateFindingsFilter(
            UpdateFindingsFilterRequest updateFindingsFilterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFindingsFilterRequest, UpdateFindingsFilterResponse>()
                            .withOperationName("UpdateFindingsFilter")
                            .withMarshaller(new UpdateFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateFindingsFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.
     * </p>
     *
     * @param updateMacieSessionRequest
     * @return A Java Future containing the result of the UpdateMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMacieSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMacieSessionResponse> updateMacieSession(UpdateMacieSessionRequest updateMacieSessionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMacieSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMacieSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMacieSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMacieSessionRequest, UpdateMacieSessionResponse>()
                            .withOperationName("UpdateMacieSession")
                            .withMarshaller(new UpdateMacieSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMacieSessionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables an Amazon Macie master account to suspend or re-enable a member account.
     * </p>
     *
     * @param updateMemberSessionRequest
     * @return A Java Future containing the result of the UpdateMemberSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMemberSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMemberSessionResponse> updateMemberSession(
            UpdateMemberSessionRequest updateMemberSessionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMemberSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMemberSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMemberSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMemberSessionRequest, UpdateMemberSessionResponse>()
                            .withOperationName("UpdateMemberSession")
                            .withMarshaller(new UpdateMemberSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMemberSessionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates Amazon Macie configuration settings for an AWS organization.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOrganizationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse>()
                            .withOperationName("UpdateOrganizationConfiguration")
                            .withMarshaller(new UpdateOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateOrganizationConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Macie2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
