/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest;
import software.amazon.awssdk.services.macie.model.AssociateMemberAccountResponse;
import software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest;
import software.amazon.awssdk.services.macie.model.DisassociateMemberAccountResponse;
import software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.UpdateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.paginators.ListMemberAccountsPublisher;
import software.amazon.awssdk.services.macie.paginators.ListS3ResourcesPublisher;

/**
 * Service client for accessing Amazon Macie asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Macie Classic</fullname>
 * <p>
 * Amazon Macie Classic is a security service that uses machine learning to automatically discover, classify, and
 * protect sensitive data in AWS. Macie Classic recognizes sensitive data such as personally identifiable information
 * (PII) or intellectual property, and provides you with dashboards and alerts that give visibility into how this data
 * is being accessed or moved. For more information, see the <a
 * href="https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html">Amazon Macie Classic User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface MacieAsyncClient extends SdkClient {
    String SERVICE_NAME = "macie";

    /**
     * Create a {@link MacieAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MacieAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MacieAsyncClient}.
     */
    static MacieAsyncClientBuilder builder() {
        return new DefaultMacieAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates a specified AWS account with Amazon Macie Classic as a member account.
     * </p>
     *
     * @param associateMemberAccountRequest
     * @return A Java Future containing the result of the AssociateMemberAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.AssociateMemberAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateMemberAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberAccountResponse> associateMemberAccount(
            AssociateMemberAccountRequest associateMemberAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specified AWS account with Amazon Macie Classic as a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberAccountRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberAccountRequest#builder()}
     * </p>
     *
     * @param associateMemberAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateMemberAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.AssociateMemberAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateMemberAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateMemberAccountResponse> associateMemberAccount(
            Consumer<AssociateMemberAccountRequest.Builder> associateMemberAccountRequest) {
        return associateMemberAccount(AssociateMemberAccountRequest.builder().applyMutation(associateMemberAccountRequest)
                .build());
    }

    /**
     * <p>
     * Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification. If
     * memberAccountId isn't specified, the action associates specified S3 resources with Macie Classic for the current
     * Macie Classic administrator account. If memberAccountId is specified, the action associates specified S3
     * resources with Macie Classic for the specified member account.
     * </p>
     *
     * @param associateS3ResourcesRequest
     * @return A Java Future containing the result of the AssociateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.AssociateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateS3ResourcesResponse> associateS3Resources(
            AssociateS3ResourcesRequest associateS3ResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification. If
     * memberAccountId isn't specified, the action associates specified S3 resources with Macie Classic for the current
     * Macie Classic administrator account. If memberAccountId is specified, the action associates specified S3
     * resources with Macie Classic for the specified member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateS3ResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateS3ResourcesRequest#builder()}
     * </p>
     *
     * @param associateS3ResourcesRequest
     *        A {@link Consumer} that will call methods on {@link AssociateS3ResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current AWS account limits. The error code describes the limit exceeded.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.AssociateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateS3ResourcesResponse> associateS3Resources(
            Consumer<AssociateS3ResourcesRequest.Builder> associateS3ResourcesRequest) {
        return associateS3Resources(AssociateS3ResourcesRequest.builder().applyMutation(associateS3ResourcesRequest).build());
    }

    /**
     * <p>
     * Removes the specified member account from Amazon Macie Classic.
     * </p>
     *
     * @param disassociateMemberAccountRequest
     * @return A Java Future containing the result of the DisassociateMemberAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.DisassociateMemberAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateMemberAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberAccountResponse> disassociateMemberAccount(
            DisassociateMemberAccountRequest disassociateMemberAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified member account from Amazon Macie Classic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberAccountRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateMemberAccountRequest#builder()}
     * </p>
     *
     * @param disassociateMemberAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMemberAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMemberAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.DisassociateMemberAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateMemberAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberAccountResponse> disassociateMemberAccount(
            Consumer<DisassociateMemberAccountRequest.Builder> disassociateMemberAccountRequest) {
        return disassociateMemberAccount(DisassociateMemberAccountRequest.builder()
                .applyMutation(disassociateMemberAccountRequest).build());
    }

    /**
     * <p>
     * Removes specified S3 resources from being monitored by Amazon Macie Classic. If memberAccountId isn't specified,
     * the action removes specified S3 resources from Macie Classic for the current Macie Classic administrator account.
     * If memberAccountId is specified, the action removes specified S3 resources from Macie Classic for the specified
     * member account.
     * </p>
     *
     * @param disassociateS3ResourcesRequest
     * @return A Java Future containing the result of the DisassociateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.DisassociateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateS3Resources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateS3ResourcesResponse> disassociateS3Resources(
            DisassociateS3ResourcesRequest disassociateS3ResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified S3 resources from being monitored by Amazon Macie Classic. If memberAccountId isn't specified,
     * the action removes specified S3 resources from Macie Classic for the current Macie Classic administrator account.
     * If memberAccountId is specified, the action removes specified S3 resources from Macie Classic for the specified
     * member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateS3ResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateS3ResourcesRequest#builder()}
     * </p>
     *
     * @param disassociateS3ResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateS3ResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.DisassociateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateS3Resources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateS3ResourcesResponse> disassociateS3Resources(
            Consumer<DisassociateS3ResourcesRequest.Builder> disassociateS3ResourcesRequest) {
        return disassociateS3Resources(DisassociateS3ResourcesRequest.builder().applyMutation(disassociateS3ResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccounts(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(ListMemberAccountsRequest listMemberAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException Internal server error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccountsPaginator(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action
     * lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If
     * memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified
     * member account.
     * </p>
     *
     * @param listS3ResourcesRequest
     * @return A Java Future containing the result of the ListS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListS3ResourcesResponse> listS3Resources(ListS3ResourcesRequest listS3ResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action
     * lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If
     * memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified
     * member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListS3ResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListS3ResourcesRequest#builder()}
     * </p>
     *
     * @param listS3ResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListS3ResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListS3ResourcesResponse> listS3Resources(
            Consumer<ListS3ResourcesRequest.Builder> listS3ResourcesRequest) {
        return listS3Resources(ListS3ResourcesRequest.builder().applyMutation(listS3ResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action
     * lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If
     * memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified
     * member account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listS3Resources(software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListS3ResourcesPublisher publisher = client.listS3ResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListS3ResourcesPublisher publisher = client.listS3ResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listS3Resources(software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listS3ResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListS3ResourcesPublisher listS3ResourcesPaginator(ListS3ResourcesRequest listS3ResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action
     * lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If
     * memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified
     * member account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listS3Resources(software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListS3ResourcesPublisher publisher = client.listS3ResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie.paginators.ListS3ResourcesPublisher publisher = client.listS3ResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listS3Resources(software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListS3ResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListS3ResourcesRequest#builder()}
     * </p>
     *
     * @param listS3ResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListS3ResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.ListS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListS3ResourcesPublisher listS3ResourcesPaginator(Consumer<ListS3ResourcesRequest.Builder> listS3ResourcesRequest) {
        return listS3ResourcesPaginator(ListS3ResourcesRequest.builder().applyMutation(listS3ResourcesRequest).build());
    }

    /**
     * <p>
     * Updates the classification types for the specified S3 resources. If memberAccountId isn't specified, the action
     * updates the classification types of the S3 resources associated with Amazon Macie Classic for the current Macie
     * Classic administrator account. If memberAccountId is specified, the action updates the classification types of
     * the S3 resources associated with Macie Classic for the specified member account.
     * </p>
     *
     * @param updateS3ResourcesRequest
     * @return A Java Future containing the result of the UpdateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.UpdateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/UpdateS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateS3ResourcesResponse> updateS3Resources(UpdateS3ResourcesRequest updateS3ResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the classification types for the specified S3 resources. If memberAccountId isn't specified, the action
     * updates the classification types of the S3 resources associated with Amazon Macie Classic for the current Macie
     * Classic administrator account. If memberAccountId is specified, the action updates the classification types of
     * the S3 resources associated with Macie Classic for the specified member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateS3ResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateS3ResourcesRequest#builder()}
     * </p>
     *
     * @param updateS3ResourcesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateS3ResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateS3Resources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>AccessDeniedException You do not have required permissions to access the requested resource.</li>
     *         <li>InternalException Internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MacieException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MacieAsyncClient.UpdateS3Resources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/UpdateS3Resources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateS3ResourcesResponse> updateS3Resources(
            Consumer<UpdateS3ResourcesRequest.Builder> updateS3ResourcesRequest) {
        return updateS3Resources(UpdateS3ResourcesRequest.builder().applyMutation(updateS3ResourcesRequest).build());
    }
}
