/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;

public class DescribeEvaluationsIterable
implements SdkIterable<DescribeEvaluationsResponse> {
    private final MachineLearningClient client;
    private final DescribeEvaluationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEvaluationsIterable(MachineLearningClient client, DescribeEvaluationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEvaluationsResponseFetcher();
    }

    public Iterator<DescribeEvaluationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Evaluation> results() {
        Function<DescribeEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeEvaluationsIterable resume(DescribeEvaluationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEvaluationsIterable(this.client, (DescribeEvaluationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEvaluationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEvaluationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEvaluationsResponseFetcher
    implements SyncPageFetcher<DescribeEvaluationsResponse> {
        private DescribeEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEvaluationsResponse nextPage(DescribeEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEvaluationsIterable.this.client.describeEvaluations(DescribeEvaluationsIterable.this.firstRequest);
            }
            return DescribeEvaluationsIterable.this.client.describeEvaluations((DescribeEvaluationsRequest)((Object)DescribeEvaluationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

