/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceFromRdsRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromRdsRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(CreateDataSourceFromRdsRequest.getter(CreateDataSourceFromRdsRequest::dataSourceId)).setter(CreateDataSourceFromRdsRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceName").getter(CreateDataSourceFromRdsRequest.getter(CreateDataSourceFromRdsRequest::dataSourceName)).setter(CreateDataSourceFromRdsRequest.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()}).build();
    private static final SdkField<RDSDataSpec> RDS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RDSData").getter(CreateDataSourceFromRdsRequest.getter(CreateDataSourceFromRdsRequest::rdsData)).setter(CreateDataSourceFromRdsRequest.setter(Builder::rdsData)).constructor(RDSDataSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RDSData").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CreateDataSourceFromRdsRequest.getter(CreateDataSourceFromRdsRequest::roleARN)).setter(CreateDataSourceFromRdsRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ComputeStatistics").getter(CreateDataSourceFromRdsRequest.getter(CreateDataSourceFromRdsRequest::computeStatistics)).setter(CreateDataSourceFromRdsRequest.setter(Builder::computeStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, DATA_SOURCE_NAME_FIELD, RDS_DATA_FIELD, ROLE_ARN_FIELD, COMPUTE_STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSourceId", DATA_SOURCE_ID_FIELD);
            this.put("DataSourceName", DATA_SOURCE_NAME_FIELD);
            this.put("RDSData", RDS_DATA_FIELD);
            this.put("RoleARN", ROLE_ARN_FIELD);
            this.put("ComputeStatistics", COMPUTE_STATISTICS_FIELD);
        }
    });
    private final String dataSourceId;
    private final String dataSourceName;
    private final RDSDataSpec rdsData;
    private final String roleARN;
    private final Boolean computeStatistics;

    private CreateDataSourceFromRdsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.rdsData = builder.rdsData;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final RDSDataSpec rdsData() {
        return this.rdsData;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final Boolean computeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsData());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRdsRequest)) {
            return false;
        }
        CreateDataSourceFromRdsRequest other = (CreateDataSourceFromRdsRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.rdsData(), other.rdsData()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceFromRdsRequest").add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceName", (Object)this.dataSourceName()).add("RDSData", (Object)this.rdsData()).add("RoleARN", (Object)this.roleARN()).add("ComputeStatistics", (Object)this.computeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "RDSData": {
                return Optional.ofNullable(clazz.cast(this.rdsData()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.ofNullable(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromRdsRequest, T> g) {
        return obj -> g.apply((CreateDataSourceFromRdsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private RDSDataSpec rdsData;
        private String roleARN;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRdsRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.rdsData(model.rdsData);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final RDSDataSpec.Builder getRdsData() {
            return this.rdsData != null ? this.rdsData.toBuilder() : null;
        }

        public final void setRdsData(RDSDataSpec.BuilderImpl rdsData) {
            this.rdsData = rdsData != null ? rdsData.build() : null;
        }

        @Override
        public final Builder rdsData(RDSDataSpec rdsData) {
            this.rdsData = rdsData;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRdsRequest build() {
            return new CreateDataSourceFromRdsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceFromRdsRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder rdsData(RDSDataSpec var1);

        default public Builder rdsData(Consumer<RDSDataSpec.Builder> rdsData) {
            return this.rdsData((RDSDataSpec)((RDSDataSpec.Builder)RDSDataSpec.builder().applyMutation(rdsData)).build());
        }

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

